/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.define;

import java.util.function.Function;
import java.util.stream.Stream;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.define.Define;
import org.anchoranalysis.bean.define.DefineAddException;
import org.anchoranalysis.bean.define.adder.DefineAdderBean;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.image.bean.provider.MaskProvider;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.mpp.bean.provider.MarkCollectionProvider;
import org.anchoranalysis.plugin.mpp.bean.define.CreateVisualizatonHelper;

public class VisualizeOnBackground
extends DefineAdderBean {
    private static final String SUFFIX = ".visualize";
    @BeanField
    private DefineAdderBean add;
    @BeanField
    private String backgroundID;
    @BeanField
    private int outlineWidth = 1;
    @BeanField
    private boolean stackBackground = false;

    public void addTo(Define define) throws DefineAddException {
        Define delegate = this.fromDelegate();
        define.addAll(delegate);
        CreateVisualizatonHelper creator = new CreateVisualizatonHelper(this.backgroundID, this.outlineWidth, this.stackBackground);
        this.addVisualizationFor(delegate, define, MaskProvider.class, creator::mask);
        this.addVisualizationFor(delegate, define, ObjectCollectionProvider.class, creator::objects);
        this.addVisualizationFor(delegate, define, MarkCollectionProvider.class, creator::marks);
    }

    private Define fromDelegate() throws DefineAddException {
        Define def = new Define();
        this.add.addTo(def);
        return def;
    }

    private void addVisualizationFor(Define in, Define out, Class<?> listType, Function<String, StackProvider> createVisualization) throws DefineAddException {
        Stream<String> beanNames = in.listFor(listType).stream().map(NamedBean::getName);
        CheckedStream.forEach(beanNames, DefineAddException.class, name -> out.add(this.visualizationBean(createVisualization, (String)name)));
    }

    private NamedBean<StackProvider> visualizationBean(Function<String, StackProvider> createVisualization, String inputName) {
        return new NamedBean(inputName + SUFFIX, (AnchorBean)createVisualization.apply(inputName));
    }

    public DefineAdderBean getAdd() {
        return this.add;
    }

    public void setAdd(DefineAdderBean add) {
        this.add = add;
    }

    public String getBackgroundID() {
        return this.backgroundID;
    }

    public void setBackgroundID(String backgroundID) {
        this.backgroundID = backgroundID;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    public boolean isStackBackground() {
        return this.stackBackground;
    }

    public void setStackBackground(boolean stackBackground) {
        this.stackBackground = stackBackground;
    }
}

