/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.define;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.define.Define;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.experiment.io.InitializationContext;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.mpp.io.input.ExportSharedObjects;
import org.anchoranalysis.mpp.io.input.MarksInitializationFactory;
import org.anchoranalysis.mpp.io.input.MultiInput;
import org.anchoranalysis.mpp.io.output.EnergyStackWriter;
import org.anchoranalysis.plugin.mpp.bean.define.SharedObjectsOutputter;

public class DefineOutputter
extends AnchorBean<DefineOutputter> {
    @BeanField
    @OptionalBean
    private Define define = new Define();
    @BeanField
    private boolean suppressSubfolders = false;

    public void addAllOutputNamesTo(OutputEnabledMutable outputEnabled) {
        SharedObjectsOutputter.addAllOutputNamesTo(outputEnabled);
    }

    public <S> void process(InputBound<MultiInput, S> input, Processor<ImageInitialization> operation) throws OperationFailedException {
        InitializationContext context = input.createInitializationContext();
        try {
            ImageInitialization initialization = this.createInitialization(context, (ExportSharedObjects)input.getInput());
            operation.process(initialization);
            this.outputSharedObjects(initialization.sharedObjects(), Optional.empty(), context.getOutputter());
        }
        catch (CreateException | OutputWriteFailedException e) {
            throw new OperationFailedException(e);
        }
    }

    protected ImageInitialization createInitialization(InitializationContext context, ExportSharedObjects input) throws CreateException {
        return MarksInitializationFactory.create(Optional.of(input), (InitializationContext)context, Optional.ofNullable(this.define)).image();
    }

    protected ImageInitialization createInitialization(InitializationContext context, Optional<SharedObjects> sharedObjects, Optional<Dictionary> dictionary) throws CreateException {
        ImageInitialization initialization = MarksInitializationFactory.create(Optional.empty(), (InitializationContext)context, Optional.ofNullable(this.define)).image();
        try {
            initialization.addSharedObjectsDictionary(sharedObjects, dictionary);
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
        return initialization;
    }

    protected void outputSharedObjects(SharedObjects sharedObjects, Optional<EnergyStack> energyStack, Outputter outputter) throws OutputWriteFailedException {
        new SharedObjectsOutputter(sharedObjects, this.suppressSubfolders, outputter.getChecked()).output();
        if (energyStack.isPresent()) {
            new EnergyStackWriter(energyStack.get(), outputter).writeEnergyStack();
        }
    }

    @Generated
    public Define getDefine() {
        return this.define;
    }

    @Generated
    public void setDefine(Define define) {
        this.define = define;
    }

    @Generated
    public boolean isSuppressSubfolders() {
        return this.suppressSubfolders;
    }

    @Generated
    public void setSuppressSubfolders(boolean suppressSubfolders) {
        this.suppressSubfolders = suppressSubfolders;
    }

    @FunctionalInterface
    public static interface Processor<T> {
        public void process(T var1) throws OperationFailedException;
    }
}

