/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.define;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.experiment.io.InitializationContext;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.mpp.io.input.ExportSharedObjects;
import org.anchoranalysis.plugin.image.provider.ReferenceFactory;
import org.anchoranalysis.plugin.mpp.bean.define.DefineOutputter;

public class DefineOutputterWithEnergy
extends DefineOutputter {
    @BeanField
    private StackProvider stackEnergy = ReferenceFactory.stack((String)"energy_stack");
    @BeanField
    @OptionalBean
    private DictionaryProvider dictionary;

    public <S> void processInput(ExportSharedObjects input, InitializationContext context, ProcessWithEnergyStack<ImageInitialization, S> operation) throws OperationFailedException {
        try {
            ImageInitialization initialization = super.createInitialization(context, input);
            this.processWithEnergyStack(initialization, operation, context.getInputOutput());
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public <S> S processInput(InitializationContext context, SharedObjects sharedObjects, Optional<Dictionary> dictionary, ProcessWithEnergyStack<ImageInitialization, S> operation) throws OperationFailedException {
        try {
            ImageInitialization initialization = super.createInitialization(context, Optional.of(sharedObjects), dictionary);
            return this.processWithEnergyStack(initialization, operation, context.getInputOutput());
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private <S> S processWithEnergyStack(ImageInitialization initialization, ProcessWithEnergyStack<ImageInitialization, S> operation, InputOutputContext context) throws OperationFailedException {
        try {
            EnergyStack energyStack = this.createEnergyStack(initialization, context.getLogger());
            S result = operation.process(initialization, energyStack);
            this.outputSharedObjects(initialization.sharedObjects(), Optional.of(energyStack), context.getOutputter());
            return result;
        }
        catch (ProvisionFailedException | InitializeException | OutputWriteFailedException e) {
            throw new OperationFailedException(e);
        }
    }

    private EnergyStack createEnergyStack(ImageInitialization initialization, Logger logger) throws InitializeException, ProvisionFailedException {
        StackProvider stackDuplicated = (StackProvider)this.stackEnergy.duplicateBean();
        stackDuplicated.initializeRecursive((BeanInitialization)initialization, logger);
        EnergyStack stack = new EnergyStack((Stack)stackDuplicated.get());
        if (this.dictionary != null) {
            this.dictionary.initializeRecursive((BeanInitialization)initialization.dictionaryInitialization(), logger);
            stack.setParameters((Dictionary)this.dictionary.get());
        }
        return stack;
    }

    @Generated
    public StackProvider getStackEnergy() {
        return this.stackEnergy;
    }

    @Generated
    public void setStackEnergy(StackProvider stackEnergy) {
        this.stackEnergy = stackEnergy;
    }

    @Generated
    public DictionaryProvider getDictionary() {
        return this.dictionary;
    }

    @Generated
    public void setDictionary(DictionaryProvider dictionary) {
        this.dictionary = dictionary;
    }

    @FunctionalInterface
    public static interface ProcessWithEnergyStack<T, S> {
        public S process(T var1, EnergyStack var2) throws OperationFailedException;
    }
}

