/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.define;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.initializable.parameters.BeanInitialization;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.TaskWithoutSharedState;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.NoSharedState;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.io.bean.object.feature.OutputFeatureTable;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.mpp.io.input.MultiInput;
import org.anchoranalysis.plugin.mpp.bean.define.DefineOutputter;
import org.anchoranalysis.plugin.mpp.bean.define.EnergyStackHelper;

public class Develop
extends TaskWithoutSharedState<MultiInput> {
    @BeanField
    private DefineOutputter define;
    @BeanField
    private List<OutputFeatureTable> featureTables = Arrays.asList(new OutputFeatureTable[0]);
    @BeanField
    @AllowEmpty
    private String dictionary = "";

    public void doJobOnInput(InputBound<MultiInput, NoSharedState> input) throws JobExecutionException {
        try {
            this.define.process(input, initialization -> this.outputFeaturesAndEnergyStack((ImageInitialization)initialization, (InputOutputContext)input.getContextJob()));
        }
        catch (OperationFailedException e) {
            throw new JobExecutionException((Throwable)e);
        }
    }

    public boolean hasVeryQuickPerInputExecution() {
        return false;
    }

    public InputTypesExpected inputTypesExpected() {
        return new InputTypesExpected(MultiInput.class);
    }

    public OutputEnabledMutable defaultOutputs() {
        OutputEnabledMutable outputs = super.defaultOutputs();
        this.define.addAllOutputNamesTo(outputs);
        outputs.addEnabledOutputFirst(new String[]{"features"});
        return outputs;
    }

    private void outputFeaturesAndEnergyStack(ImageInitialization initialization, InputOutputContext context) throws OperationFailedException {
        try {
            this.outputFeatureTables(initialization, context);
        }
        catch (IOException e) {
            throw new OperationFailedException((Throwable)e);
        }
        EnergyStackHelper.writeEnergyStackDictionary(initialization, OptionalFactory.create((String)this.dictionary), context);
    }

    private void outputFeatureTables(ImageInitialization initialization, InputOutputContext context) throws IOException {
        for (OutputFeatureTable outputFeatureTable : this.featureTables) {
            try {
                outputFeatureTable.initializeRecursive((BeanInitialization)initialization, context.getLogger());
            }
            catch (InitializeException e) {
                throw new IOException(e);
            }
            outputFeatureTable.output(context);
        }
    }

    @Generated
    public DefineOutputter getDefine() {
        return this.define;
    }

    @Generated
    public void setDefine(DefineOutputter define) {
        this.define = define;
    }

    @Generated
    public List<OutputFeatureTable> getFeatureTables() {
        return this.featureTables;
    }

    @Generated
    public void setFeatureTables(List<OutputFeatureTable> featureTables) {
        this.featureTables = featureTables;
    }

    @Generated
    public String getDictionary() {
        return this.dictionary;
    }

    @Generated
    public void setDictionary(String dictionary) {
        this.dictionary = dictionary;
    }
}

