/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.mpp.bean.define;

import lombok.Generated;
import org.anchoranalysis.core.identifier.provider.NamedProvider;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.io.histogram.output.HistogramCSVGenerator;
import org.anchoranalysis.image.io.object.output.hdf5.ObjectCollectionWriter;
import org.anchoranalysis.image.io.stack.output.NamedStacksOutputter;
import org.anchoranalysis.io.generator.Generator;
import org.anchoranalysis.io.generator.collection.NamedProviderOutputter;
import org.anchoranalysis.io.generator.serialized.XStreamGenerator;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.mpp.init.MarksInitialization;

class SharedObjectsOutputter {
    private SharedObjects sharedObjects;
    private boolean suppressSubfolders;
    private OutputterChecked outputter;

    public static void addAllOutputNamesTo(OutputEnabledMutable outputEnabled) {
        outputEnabled.addEnabledOutputFirst(new String[]{"stacks", "marks", "histograms", "objects"});
    }

    public void output() throws OutputWriteFailedException {
        if (!this.outputter.getSettings().hasBeenInitialized()) {
            throw new OutputWriteFailedException("The Outputter's settings have not yet been initialized");
        }
        ImageInitialization initializationImage = new ImageInitialization(this.sharedObjects);
        this.stacks(initializationImage);
        this.histograms(initializationImage);
        this.objects(initializationImage);
        this.marks(new MarksInitialization(initializationImage));
    }

    private void stacks(ImageInitialization initialization) throws OutputWriteFailedException {
        NamedStacksOutputter.output((NamedProvider)initialization.combinedStacks(), (String)"stacks", (boolean)this.suppressSubfolders, (OutputterChecked)this.outputter);
    }

    private void marks(MarksInitialization initialization) throws OutputWriteFailedException {
        this.output((NamedProviderStore)initialization.marks(), (Generator)new XStreamGenerator(), "marks");
    }

    private void histograms(ImageInitialization initialization) throws OutputWriteFailedException {
        this.output((NamedProviderStore)initialization.histograms(), (Generator)new HistogramCSVGenerator(), "histograms");
    }

    private void objects(ImageInitialization initialization) throws OutputWriteFailedException {
        this.output(initialization.objects(), ObjectCollectionWriter.generator(), "objects");
    }

    private <T> void output(NamedProviderStore<T> store, Generator<T> generator, String directoryName) throws OutputWriteFailedException {
        new NamedProviderOutputter(store, generator, this.outputter).output(directoryName, this.suppressSubfolders);
    }

    @Generated
    public SharedObjectsOutputter(SharedObjects sharedObjects, boolean suppressSubfolders, OutputterChecked outputter) {
        this.sharedObjects = sharedObjects;
        this.suppressSubfolders = suppressSubfolders;
        this.outputter = outputter;
    }
}

