/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.onnx.bean.object.segment.decode.instance.maskrcnn;

import java.nio.FloatBuffer;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferWrap;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.spatial.box.Extent;

class ExtractMaskHelper {
    private static final int WIDTH_HEIGHT_MASK = 28;
    private static final int NUMBER_PIXELS_MASK = 784;

    public static void checkMaskBufferSize(FloatBuffer buffer, int numberProposals) throws OperationFailedException {
        if (buffer.capacity() != 784 * numberProposals) {
            throw new OperationFailedException(String.format("We expect %d number of pixels in each mask, but this isn't true.", 784));
        }
    }

    public static Optional<Voxels<FloatBuffer>> maskAtIndex(FloatBuffer buffer, int index, float minMaskValue) {
        float[] extractedMaskPixels = new float[784];
        VoxelBuffer voxelBuffer = VoxelBufferWrap.floatArray((float[])extractedMaskPixels);
        buffer.position(index * 784);
        buffer.get(extractedMaskPixels);
        if (!ExtractMaskHelper.hasPixelAboveThreshold(extractedMaskPixels, minMaskValue)) {
            return Optional.empty();
        }
        Voxels voxels = VoxelsFactory.getFloat().createForVoxelBuffer(voxelBuffer, new Extent(28, 28, 1));
        return Optional.of(voxels);
    }

    private static boolean hasPixelAboveThreshold(float[] array, float minMaskValue) {
        for (int i = 0; i < array.length; ++i) {
            if (!(array[i] >= minMaskValue)) continue;
            return true;
        }
        return false;
    }

    private ExtractMaskHelper() {
    }
}

