/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.onnx.bean.object.segment.decode.instance.maskrcnn;

import java.nio.FloatBuffer;
import java.nio.LongBuffer;
import java.util.Optional;
import org.anchoranalysis.image.inference.ImageInferenceContext;
import org.anchoranalysis.image.inference.segment.DualScale;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.inference.segment.MultiScaleObject;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.plugin.onnx.bean.object.segment.decode.instance.maskrcnn.ExtractMaskHelper;
import org.anchoranalysis.plugin.onnx.bean.object.segment.decode.instance.maskrcnn.ScaleMaskHelper;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class ExtractObjectHelper {
    private static final String OBJECT_CLASS_LABEL_FALLBACK = "unknown";

    public static Optional<LabelledWithConfidence<MultiScaleObject>> extractAt(int index, FloatBuffer scores, FloatBuffer masks, LongBuffer labels, FloatBuffer boxes, float minMaskValue, ImageInferenceContext context) {
        Optional<Voxels<FloatBuffer>> maskVoxels = ExtractMaskHelper.maskAtIndex(masks, index, minMaskValue);
        if (maskVoxels.isPresent()) {
            double score = scores.get(index);
            String label = ExtractObjectHelper.deriveLabel(labels, index, context);
            BoundingBox box = ExtractObjectHelper.boxAtIndex(boxes, index);
            MultiScaleObject objectAtScale = MultiScaleObject.extractFrom((DualScale)context.scaleFactorUpscale(), (DualScale)context.getDimensions(), (factor, dimensions) -> ScaleMaskHelper.scaleMaskToFitBox((Voxels<FloatBuffer>)((Voxels)maskVoxels.get()), box, factor, context.getResizer(), dimensions, minMaskValue, context.getExecutionTimeRecorder()));
            return Optional.of(new LabelledWithConfidence((Object)objectAtScale, score, label));
        }
        return Optional.empty();
    }

    private static BoundingBox boxAtIndex(FloatBuffer buffer, int boxIndex) {
        int indexMin = boxIndex * 4;
        Point3d min = new Point3d((double)buffer.get(indexMin), (double)buffer.get(indexMin + 1), 0.0);
        Point3d max = new Point3d((double)buffer.get(indexMin + 2), (double)buffer.get(indexMin + 3), 0.0);
        return BoundingBox.createReuse((ReadableTuple3i)PointConverter.intFromDouble((Point3d)min, (boolean)true), (ReadableTuple3i)PointConverter.intFromDouble((Point3d)max, (boolean)true));
    }

    private static String deriveLabel(LongBuffer labels, int index, ImageInferenceContext context) {
        return context.getClassLabels().map(labelList -> (String)labelList.get((int)labels.get(index))).orElse(OBJECT_CLASS_LABEL_FALLBACK);
    }

    private ExtractObjectHelper() {
    }
}

