/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.onnx.bean.object.segment.decode.instance.maskrcnn;

import java.nio.FloatBuffer;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.inference.segment.ScaleAndThresholdVoxels;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.ScaleFactor;

class ScaleMaskHelper {
    public static ObjectMask scaleMaskToFitBox(Voxels<FloatBuffer> maskVoxels, BoundingBox box, Optional<ScaleFactor> scaleFactor, VoxelsResizer resizer, Dimensions clampTo, float minMaskValue, ExecutionTimeRecorder executionTimeRecorder) {
        box = ScaleMaskHelper.clampMaybeScaleBox(box, scaleFactor, clampTo.extent());
        return ScaleMaskHelper.scaleMaskToBox(maskVoxels, box, resizer, minMaskValue, executionTimeRecorder);
    }

    private static BoundingBox clampMaybeScaleBox(BoundingBox box, Optional<ScaleFactor> scaleFactor, Extent extent) {
        if (scaleFactor.isPresent()) {
            return box.scale(scaleFactor.get()).clampTo(extent);
        }
        return box.clampTo(extent);
    }

    private static ObjectMask scaleMaskToBox(Voxels<FloatBuffer> voxels, BoundingBox box, VoxelsResizer resizer, float minMaskValue, ExecutionTimeRecorder executionTimeRecorder) {
        BinaryVoxels scaledMask = (BinaryVoxels)executionTimeRecorder.recordExecutionTime("Scale and threshold mask", () -> ScaleAndThresholdVoxels.scaleAndThreshold((Voxels)voxels, (Extent)box.extent(), (VoxelsResizer)resizer, (float)minMaskValue));
        return new ObjectMask(box, scaledMask);
    }

    @Generated
    private ScaleMaskHelper() {
    }
}

