/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.onnx.bean.object.segment.stack;

import java.nio.FloatBuffer;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.spatial.box.Extent;

class BufferFromStack {
    public static FloatBuffer createFrom(Stack stack, Optional<double[]> subtractMeans, boolean interleaveChannels) throws OperationFailedException {
        BufferFromStack.checkChannels(stack);
        Dimensions dimensions = stack.getChannel(0).dimensions();
        FloatBuffer buffer = FloatBuffer.allocate((int)dimensions.calculateVolume() * stack.getNumberChannels());
        if (subtractMeans.isPresent() && subtractMeans.get().length != stack.getNumberChannels()) {
            throw new OperationFailedException(String.format("subtractMeans has size=%d whereas the stack has %d channels. They must be equal.", subtractMeans.get().length, stack.getNumberChannels()));
        }
        if (interleaveChannels) {
            BufferFromStack.copyChannelLast(buffer, stack, subtractMeans);
        } else {
            BufferFromStack.copyChannelFirst(buffer, stack, subtractMeans);
        }
        return buffer;
    }

    private static void checkChannels(Stack stack) throws OperationFailedException {
        for (int channelIndex = 0; channelIndex < stack.getNumberChannels(); ++channelIndex) {
            if (stack.getChannel(channelIndex).getVoxelDataType() == UnsignedByteVoxelType.INSTANCE) continue;
            throw new OperationFailedException(String.format("Only unsigned-byte channels are supported for conversion into an ONNX Runtime tensor, but channel %d is %s", channelIndex, stack.getChannel(channelIndex).getVoxelDataType()));
        }
    }

    private static void copyChannelFirst(FloatBuffer buffer, Stack stack, Optional<double[]> subtractMeans) {
        for (int channelIndex = 0; channelIndex < stack.getNumberChannels(); ++channelIndex) {
            Channel channel = stack.getChannel(channelIndex);
            float valueToRemove = subtractMeans.isPresent() ? (float)subtractMeans.get()[channelIndex] : 0.0f;
            BufferFromStack.copyChannelIntoBuffer((Voxels<UnsignedByteBuffer>)channel.voxels().asByte(), buffer, valueToRemove);
        }
    }

    private static float[] convertToFloat(double[] values) {
        return new float[]{(float)values[0], (float)values[1], (float)values[2]};
    }

    private static void updateBuffers(Stack stack, int z, UnsignedByteBuffer[] sliceBuffers) {
        for (int channelIndex = 0; channelIndex < stack.getNumberChannels(); ++channelIndex) {
            UnsignedByteBuffer buffer = (UnsignedByteBuffer)stack.getChannel(channelIndex).voxels().asByte().slice(z).buffer();
            buffer.rewind();
            sliceBuffers[channelIndex] = buffer;
        }
    }

    private static void copyChannelIntoBuffer(Voxels<UnsignedByteBuffer> voxels, FloatBuffer destination, float valueToRemove) {
        Extent extent = voxels.extent();
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedByteBuffer buffer = (UnsignedByteBuffer)voxels.sliceBuffer(z);
            for (int index = 0; index < extent.areaXY(); ++index) {
                float value = buffer.getUnsigned();
                destination.put(value - valueToRemove);
            }
        }
    }

    private static void copyChannelLast(FloatBuffer buffer, Stack stack, Optional<double[]> subtractMeans) {
        float[] valuesToRemove = subtractMeans.isPresent() ? BufferFromStack.convertToFloat(subtractMeans.get()) : new float[3];
        UnsignedByteBuffer[] sliceBuffers = new UnsignedByteBuffer[stack.getNumberChannels()];
        Extent extent = stack.getChannel(0).extent();
        for (int z = 0; z < extent.z(); ++z) {
            BufferFromStack.updateBuffers(stack, z, sliceBuffers);
            for (int index = 0; index < extent.areaXY(); ++index) {
                for (int channelIndex = 0; channelIndex < stack.getNumberChannels(); ++channelIndex) {
                    float value = sliceBuffers[channelIndex].getUnsigned();
                    buffer.put(value - valuesToRemove[channelIndex]);
                }
            }
        }
    }

    @Generated
    private BufferFromStack() {
    }
}

