/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.onnx.model;

import ai.onnxruntime.OnnxTensor;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtSession;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.image.inference.ImageInferenceModel;

public class OnnxModel
implements ImageInferenceModel<OnnxTensor> {
    private OrtSession session;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S> S performInference(OnnxTensor input, String inputName, List<String> outputNames, CheckedFunction<List<OnnxTensor>, S, OperationFailedException> convertFunction) throws OperationFailedException {
        HashMap<String, OnnxTensor> inputs = new HashMap<String, OnnxTensor>();
        inputs.put(inputName, input);
        try (OrtSession.Result result = this.session.run(inputs);){
            List<OnnxTensor> tensors = OnnxModel.tensorsFromResult(result, outputNames);
            Object object = convertFunction.apply(tensors);
            return (S)object;
        }
        catch (OrtException e) {
            throw new OperationFailedException("Inference failed with the ONNX Runtime", (Throwable)e);
        }
    }

    private static List<OnnxTensor> tensorsFromResult(OrtSession.Result result, List<String> outputNames) throws OperationFailedException {
        ArrayList<OnnxTensor> out = new ArrayList<OnnxTensor>(outputNames.size());
        for (String identifier : outputNames) {
            OnnxTensor resultTensor = (OnnxTensor)result.get(identifier).orElseThrow(() -> new OperationFailedException(String.format("No output tensor with name '%s' exists", identifier)));
            out.add(resultTensor);
        }
        return out;
    }

    public void close() throws OperationFailedException {
        try {
            this.session.close();
        }
        catch (Exception e) {
            throw new OperationFailedException("An error occured closing a Onnx session", (Throwable)e);
        }
        finally {
            this.session = null;
        }
    }

    @Generated
    public OnnxModel(OrtSession session) {
        this.session = session;
    }
}

