/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.opencv.CVInit;
import org.anchoranalysis.plugin.opencv.convert.ConvertToMat;
import org.anchoranalysis.spatial.point.Contour;
import org.anchoranalysis.spatial.point.Point3f;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.Point;
import org.opencv.imgproc.Imgproc;

public class CVFindContours {
    public static List<Contour> contoursForObject(ObjectMask object) throws OperationFailedException {
        CVInit.blockUntilLoaded();
        try {
            Mat mat = ConvertToMat.fromObject(object.duplicate());
            LinkedList<MatOfPoint> contours = new LinkedList<MatOfPoint>();
            Imgproc.findContours((Mat)mat, contours, (Mat)new Mat(), (int)0, (int)1);
            return CVFindContours.convertMatOfPoint(contours, object.boundingBox().cornerMin());
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static List<Contour> convertMatOfPoint(List<MatOfPoint> matrices, ReadableTuple3i cornerMin) {
        return FunctionalList.mapToList(matrices, points -> CVFindContours.createContour(points, cornerMin));
    }

    private static Contour createContour(MatOfPoint matrix, ReadableTuple3i cornerMin) {
        Contour contour = new Contour();
        Arrays.stream(matrix.toArray()).map(point -> CVFindContours.convert(point, cornerMin)).forEach(contour.getPoints()::add);
        return contour;
    }

    private static Point3f convert(Point point, ReadableTuple3i toAdd) {
        return new Point3f(CVFindContours.addDoubles(point.x, toAdd.x()), CVFindContours.addDoubles(point.y, toAdd.y()), (float)toAdd.z());
    }

    private static float addDoubles(double value1, double value2) {
        return (float)(value1 + value2);
    }

    private CVFindContours() {
    }

    static {
        CVInit.alwaysExecuteBeforeCallingLibrary();
    }
}

