/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.color;

import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.stack.StackProviderUnary;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.plugin.opencv.CVInit;
import org.anchoranalysis.plugin.opencv.convert.ConvertFromMat;
import org.anchoranalysis.plugin.opencv.convert.ConvertToMat;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;

public abstract class ColorConverterBase
extends StackProviderUnary {
    public Stack createFromStack(Stack stackRGB) throws ProvisionFailedException {
        this.checkNumberChannels(stackRGB);
        CVInit.blockUntilLoaded();
        try {
            Mat matBGR = ConvertToMat.makeRGBStack(stackRGB, true);
            Mat matHSV = ColorConverterBase.convertColorSpace(stackRGB.extent(), matBGR, this.colorSpaceCode());
            return ConvertFromMat.toStack(matHSV);
        }
        catch (CreateException | OperationFailedException e) {
            throw new ProvisionFailedException(e);
        }
    }

    protected abstract int colorSpaceCode();

    private static Mat convertColorSpace(Extent extent, Mat matBGR, int code) {
        Mat matHSV = ConvertToMat.createEmptyMat(extent, CvType.CV_8UC3);
        Imgproc.cvtColor((Mat)matBGR, (Mat)matHSV, (int)code);
        return matHSV;
    }

    private void checkNumberChannels(Stack stack) throws ProvisionFailedException {
        if (stack.getNumberChannels() != 3) {
            throw new ProvisionFailedException("Input stack must have exactly 3 channels representing a RGB image");
        }
    }

    static {
        CVInit.alwaysExecuteBeforeCallingLibrary();
    }
}

