/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.feature;

import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.plugin.opencv.bean.feature.DivideUtilities;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.Size;
import org.opencv.objdetect.HOGDescriptor;

public class HOGParameters
extends AnchorBean<HOGParameters> {
    private static final String BLOCK_SIZE = "block-size";
    private static final String BLOCK_STRIDE = "block-stride";
    private static final String IMAGE_SIZE = "image-size";
    private static final String CELL_SIZE = "cell-size";
    @BeanField
    @OptionalBean
    private SizeXY windowSize;
    @BeanField
    private SizeXY blockSize = new SizeXY(16, 16);
    @BeanField
    private SizeXY blockStride = new SizeXY(8, 8);
    @BeanField
    private SizeXY cellSize = new SizeXY(8, 8);
    @BeanField
    private int numberBins = 9;
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;

    public HOGParameters(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    public int sizeDescriptor(Extent imageSize) {
        Size sizeOfWindow = this.determineWindowSize(imageSize);
        SizeXY windowStride = this.cellSize;
        int cellsPerBlock = DivideUtilities.divide(this.blockSize, this.cellSize, SizeXY::getWidth) * DivideUtilities.divide(this.blockSize, this.cellSize, SizeXY::getHeight);
        int blocksPerWindow = HOGParameters.numberSlidingWindowsFor(sizeOfWindow, HOGParameters.sizeFor(this.blockSize), this.cellSize, this.blockStride);
        int windowsPerImage = HOGParameters.numberSlidingWindowsFor(HOGParameters.sizeFor(imageSize), sizeOfWindow, this.cellSize, windowStride);
        return blocksPerWindow * cellsPerBlock * this.numberBins * windowsPerImage;
    }

    public HOGDescriptor createDescriptor(Extent imageSize) {
        return new HOGDescriptor(this.determineWindowSize(imageSize), HOGParameters.sizeFor(this.blockSize), HOGParameters.sizeFor(this.blockStride), HOGParameters.sizeFor(this.cellSize), this.numberBins);
    }

    public void checkSize(Extent extent) throws FeatureCalculationException {
        SizeXY extentAsSize = new SizeXY(extent);
        DivideUtilities.checkDivisibleBy(extentAsSize, this.blockSize, IMAGE_SIZE, BLOCK_SIZE);
        DivideUtilities.checkDivisibleBy(this.blockSize, this.cellSize, BLOCK_SIZE, CELL_SIZE);
        DivideUtilities.checkDivisibleBy(this.blockSize, this.blockStride, BLOCK_SIZE, BLOCK_STRIDE);
        DivideUtilities.checkDivisibleBy(this.blockStride, this.cellSize, BLOCK_STRIDE, CELL_SIZE);
        if (this.windowSize != null) {
            if (extent.x() < this.windowSize.getWidth()) {
                throw new FeatureCalculationException("Image width is smaller than HOG window width. This is not permitted.");
            }
            if (extent.y() < this.windowSize.getHeight()) {
                throw new FeatureCalculationException("Image height is smaller than HOG window height. This is not permitted.");
            }
        }
    }

    private Size determineWindowSize(Extent imageSize) {
        return HOGParameters.convertOr(Optional.ofNullable(this.windowSize), imageSize);
    }

    private static int numberSlidingWindowsFor(Size size, Size subtractFromSize, SizeXY addToSize, SizeXY stride) {
        int timesX = DivideUtilities.ceilDiv(size.width - subtractFromSize.width + (double)addToSize.getWidth(), stride.getWidth());
        int timesY = DivideUtilities.ceilDiv(size.height - subtractFromSize.height + (double)addToSize.getHeight(), stride.getHeight());
        return timesX * timesY;
    }

    private static Size convertOr(Optional<SizeXY> in, Extent imageSize) {
        return in.map(HOGParameters::sizeFor).orElseGet(() -> new Size((double)imageSize.x(), (double)imageSize.y()));
    }

    private static Size sizeFor(Extent extent) {
        return new Size((double)extent.x(), (double)extent.y());
    }

    private static Size sizeFor(SizeXY size) {
        return new Size((double)size.getWidth(), (double)size.getHeight());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HOGParameters)) {
            return false;
        }
        HOGParameters other = (HOGParameters)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getNumberBins() != other.getNumberBins()) {
            return false;
        }
        SizeXY this$windowSize = this.getWindowSize();
        SizeXY other$windowSize = other.getWindowSize();
        if (this$windowSize == null ? other$windowSize != null : !this$windowSize.equals(other$windowSize)) {
            return false;
        }
        SizeXY this$blockSize = this.getBlockSize();
        SizeXY other$blockSize = other.getBlockSize();
        if (this$blockSize == null ? other$blockSize != null : !this$blockSize.equals(other$blockSize)) {
            return false;
        }
        SizeXY this$blockStride = this.getBlockStride();
        SizeXY other$blockStride = other.getBlockStride();
        if (this$blockStride == null ? other$blockStride != null : !this$blockStride.equals(other$blockStride)) {
            return false;
        }
        SizeXY this$cellSize = this.getCellSize();
        SizeXY other$cellSize = other.getCellSize();
        return !(this$cellSize == null ? other$cellSize != null : !this$cellSize.equals(other$cellSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HOGParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumberBins();
        SizeXY $windowSize = this.getWindowSize();
        result = result * 59 + ($windowSize == null ? 43 : $windowSize.hashCode());
        SizeXY $blockSize = this.getBlockSize();
        result = result * 59 + ($blockSize == null ? 43 : $blockSize.hashCode());
        SizeXY $blockStride = this.getBlockStride();
        result = result * 59 + ($blockStride == null ? 43 : $blockStride.hashCode());
        SizeXY $cellSize = this.getCellSize();
        result = result * 59 + ($cellSize == null ? 43 : $cellSize.hashCode());
        return result;
    }

    public HOGParameters() {
    }

    public SizeXY getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(SizeXY windowSize) {
        this.windowSize = windowSize;
    }

    public SizeXY getBlockSize() {
        return this.blockSize;
    }

    public void setBlockSize(SizeXY blockSize) {
        this.blockSize = blockSize;
    }

    public SizeXY getBlockStride() {
        return this.blockStride;
    }

    public void setBlockStride(SizeXY blockStride) {
        this.blockStride = blockStride;
    }

    public SizeXY getCellSize() {
        return this.cellSize;
    }

    public void setCellSize(SizeXY cellSize) {
        this.cellSize = cellSize;
    }

    public int getNumberBins() {
        return this.numberBins;
    }

    public void setNumberBins(int numberBins) {
        this.numberBins = numberBins;
    }

    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

