/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.stack;

import java.nio.file.Path;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.writer.OneOrThreeChannelsWriter;
import org.anchoranalysis.image.io.bean.stack.writer.WriterErrorMessageHelper;
import org.anchoranalysis.plugin.opencv.CVInit;
import org.anchoranalysis.plugin.opencv.convert.ConvertToMat;
import org.opencv.core.Mat;
import org.opencv.imgcodecs.Imgcodecs;

public class OpenCVWriter
extends OneOrThreeChannelsWriter {
    protected void writeStackAfterCheck(Stack stack, Path filePath) throws ImageIOException {
        CVInit.blockUntilLoaded();
        try {
            boolean success = Imgcodecs.imwrite((String)filePath.toString(), (Mat)ConvertToMat.fromStack(stack));
            if (!success) {
                throw new ImageIOException("OpenCV's imwrite failed to write: " + filePath);
            }
        }
        catch (CreateException e) {
            throw WriterErrorMessageHelper.generalWriteException(OpenCVWriter.class, (Path)filePath, (Exception)((Object)e));
        }
    }

    static {
        CVInit.alwaysExecuteBeforeCallingLibrary();
    }
}

