/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.stack;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.ImagePyramidMetadata;
import org.anchoranalysis.image.core.stack.RGBChannelNames;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.CalculateOrientationChange;
import org.anchoranalysis.image.io.stack.input.ImageTimestampsAttributes;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.io.bioformats.metadata.ImageTimestampsAttributesFactory;
import org.anchoranalysis.plugin.opencv.bean.stack.OrientationChanger;
import org.anchoranalysis.plugin.opencv.convert.ConvertFromMat;
import org.opencv.core.Mat;

class OpenedRasterOpenCV
implements OpenedImageFile {
    private final Path path;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private final Optional<CalculateOrientationChange> calculateOrientation;
    private final String executionTimePrefix;
    private final CheckedFunction<Path, Mat, IOException> readDecodeMat;
    private Stack stack;
    private ImageTimestampsAttributes timestamps;

    public TimeSeries open(int seriesIndex, Logger logger) throws ImageIOException {
        this.openStackIfNecessary(logger);
        return new TimeSeries(this.stack);
    }

    public int numberSeries() {
        return 1;
    }

    public Optional<List<String>> channelNames(Logger logger) throws ImageIOException {
        this.openStackIfNecessary(logger);
        boolean includeAlpha = this.numberChannels(logger) == 4;
        return OptionalFactory.create((boolean)this.stack.isRGB(), (Object)RGBChannelNames.asList((boolean)includeAlpha));
    }

    public int numberChannels(Logger logger) throws ImageIOException {
        this.openStackIfNecessary(logger);
        return this.stack.getNumberChannels();
    }

    public int numberFrames(Logger logger) throws ImageIOException {
        return 1;
    }

    public int bitDepth(Logger logger) throws ImageIOException {
        this.openStackIfNecessary(logger);
        if (!this.stack.allChannelsHaveIdenticalType()) {
            throw new ImageIOException("Not all channels have identical channel type, so not calculating bit-depth.");
        }
        return this.stack.getChannel(0).getVoxelDataType().bitDepth();
    }

    public boolean isRGB(Logger logger) throws ImageIOException {
        this.openStackIfNecessary(logger);
        return this.stack.isRGB();
    }

    public void close() throws ImageIOException {
        this.stack = null;
    }

    public Dimensions dimensionsForSeries(int seriesIndex, Logger logger) throws ImageIOException {
        this.openStackIfNecessary(logger);
        return this.stack.dimensions();
    }

    public ImageTimestampsAttributes timestamps() throws ImageIOException {
        if (this.timestamps == null) {
            this.timestamps = ImageTimestampsAttributesFactory.fromPath((Path)this.path);
        }
        return this.timestamps;
    }

    public Optional<ImagePyramidMetadata> pyramid() throws ImageIOException {
        return Optional.empty();
    }

    private void openStackIfNecessary(Logger logger) throws ImageIOException {
        if (this.stack == null) {
            try {
                Mat image = (Mat)this.executionTimeRecorder.recordExecutionTime(this.executionTimePrefix + "reading/decoding the image.", () -> (Mat)this.readDecodeMat.apply((Object)this.path));
                OrientationChanger.changeOrientationIfNecessary(image, this.calculateOrientation, logger);
                this.stack = (Stack)this.executionTimeRecorder.recordExecutionTime(this.executionTimePrefix + "convert OpenCV to stack", () -> ConvertFromMat.toStack(image));
            }
            catch (IOException | OperationFailedException e) {
                throw new ImageIOException("Failed to convert an OpenCV image structure to a stack", e);
            }
        }
    }

    public OpenedRasterOpenCV(Path path, ExecutionTimeRecorder executionTimeRecorder, Optional<CalculateOrientationChange> calculateOrientation, String executionTimePrefix, CheckedFunction<Path, Mat, IOException> readDecodeMat) {
        this.path = path;
        this.executionTimeRecorder = executionTimeRecorder;
        this.calculateOrientation = calculateOrientation;
        this.executionTimePrefix = executionTimePrefix;
        this.readDecodeMat = readDecodeMat;
    }
}

