/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.convert;

import com.google.common.base.Preconditions;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.plugin.opencv.convert.VoxelsFromMat;
import org.anchoranalysis.plugin.opencv.convert.VoxelsRGBFromMat;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.CvType;
import org.opencv.core.Mat;

public class ConvertFromMat {
    public static Stack toStack(Mat mat) throws OperationFailedException {
        if (mat.type() == CvType.CV_8UC3) {
            return ConvertFromMat.toRGB(mat);
        }
        return ConvertFromMat.toGrayscale(mat);
    }

    private static Stack toGrayscale(Mat mat) throws OperationFailedException {
        Voxels<?> voxels = VoxelsFromMat.toVoxels(mat, ConvertFromMat.extentFrom(mat));
        return new Stack(ChannelFactory.instance().create(voxels));
    }

    private static Stack toRGB(Mat mat) throws OperationFailedException {
        return VoxelsRGBFromMat.matToRGB(mat, ConvertFromMat.extentFrom(mat));
    }

    private static Extent extentFrom(Mat mat) throws OperationFailedException {
        int width = mat.size(1);
        int height = mat.size(0);
        if (width == 0 || height == 0) {
            throw new OperationFailedException("OpenCV indicated a width or height of 0 for this file, which suggests the data-format is not supported.");
        }
        Preconditions.checkArgument((width > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0);
        return new Extent(width, height, 1);
    }

    private ConvertFromMat() {
    }
}

