/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.convert;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.function.BiConsumer;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.opencv.convert.BufferHelper;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.CvType;
import org.opencv.core.Mat;

public class ConvertToMat {
    public static Mat fromObject(ObjectMask object) throws CreateException {
        Extent extent = object.boundingBox().extent();
        if (extent.z() > 1) {
            throw new CreateException("Objects with more than 1 z-slice are not supported for OpenCV to Mat conversion (at the moment)");
        }
        return ConvertToMat.fromVoxelsByte((Voxels<UnsignedByteBuffer>)object.binaryVoxels().voxels());
    }

    public static Mat fromStack(Stack stack) throws CreateException {
        if (stack.getNumberChannels() != 1 && stack.getNumberChannels() != 3) {
            throw new CreateException("Stack must have 1 or 3 channels");
        }
        if (stack.dimensions().z() > 1) {
            throw new CreateException("Stacks with more than 1 z-stack are not supported for OpenCV to Mat conversion (at the moment)");
        }
        if (stack.getNumberChannels() == 3) {
            return ConvertToMat.makeRGBStack(stack, true);
        }
        return ConvertToMat.makeGrayscale(stack.getChannel(0));
    }

    public static Mat fromVoxelsByte(Voxels<UnsignedByteBuffer> voxels) {
        return ConvertToMat.fromVoxels(voxels, CvType.CV_8UC1, (mat, buffer) -> mat.put(0, 0, buffer.array()));
    }

    public static Mat fromVoxelsShort(Voxels<UnsignedShortBuffer> voxels) {
        return ConvertToMat.fromVoxels(voxels, CvType.CV_16UC1, (mat, buffer) -> mat.put(0, 0, buffer.array()));
    }

    public static Mat fromVoxelsFloat(Voxels<FloatBuffer> voxels) {
        return ConvertToMat.fromVoxels(voxels, CvType.CV_32FC1, (mat, buffer) -> mat.put(0, 0, buffer.array()));
    }

    public static Mat fromVoxelBufferByte(VoxelBuffer<UnsignedByteBuffer> voxelBuffer, Extent extent) {
        return ConvertToMat.fromVoxelBuffer(voxelBuffer, extent, CvType.CV_8UC1, (mat, buffer) -> mat.put(0, 0, buffer.array()));
    }

    public static Mat fromVoxelBufferShort(VoxelBuffer<UnsignedShortBuffer> voxelBuffer, Extent extent) {
        return ConvertToMat.fromVoxelBuffer(voxelBuffer, extent, CvType.CV_16UC1, (mat, buffer) -> mat.put(0, 0, buffer.array()));
    }

    public static Mat fromVoxelBufferFloat(VoxelBuffer<FloatBuffer> voxelBuffer, Extent extent) {
        return ConvertToMat.fromVoxelBuffer(voxelBuffer, extent, CvType.CV_32FC1, (mat, buffer) -> mat.put(0, 0, buffer.array()));
    }

    public static Mat makeRGBStack(Stack stack, boolean swapRedBlueChannels) throws CreateException {
        if (stack.getNumberChannels() != 3) {
            throw new CreateException("Stack must have 3 channels for RGB conversion");
        }
        VoxelDataType dataType = stack.getChannel(0).getVoxelDataType();
        if (dataType.equals((Object)UnsignedByteVoxelType.INSTANCE)) {
            if (swapRedBlueChannels) {
                return ConvertToMat.fromRGBByte(stack.getChannel(0), stack.getChannel(1), stack.getChannel(2));
            }
            return ConvertToMat.fromRGBByte(stack.getChannel(2), stack.getChannel(1), stack.getChannel(0));
        }
        throw new CreateException("Only unsigned 8-bit channels are supported for RGB");
    }

    public static Mat createEmptyMat(Extent extent, int type) {
        return new Mat(extent.y(), extent.x(), type);
    }

    private static Mat makeGrayscale(Channel channel) throws CreateException {
        if (channel.getVoxelDataType().equals((Object)UnsignedByteVoxelType.INSTANCE)) {
            return ConvertToMat.fromVoxelsByte((Voxels<UnsignedByteBuffer>)channel.voxels().asByte());
        }
        if (channel.getVoxelDataType().equals((Object)UnsignedShortVoxelType.INSTANCE)) {
            return ConvertToMat.fromVoxelsShort((Voxels<UnsignedShortBuffer>)channel.voxels().asShort());
        }
        throw new CreateException("Only unsigned 8-bit or 16-bit channels are supported");
    }

    private static <T> Mat fromVoxels(Voxels<T> voxels, int matType, BiConsumer<Mat, T> populateMat) {
        Preconditions.checkArgument((voxels.extent().z() == 1 ? 1 : 0) != 0);
        Mat mat = ConvertToMat.createEmptyMat(voxels.extent(), matType);
        populateMat.accept(mat, (Mat)voxels.sliceBuffer(0));
        return mat;
    }

    private static <T> Mat fromVoxelBuffer(VoxelBuffer<T> voxelBuffer, Extent extent, int matType, BiConsumer<Mat, T> populateMat) {
        Mat mat = ConvertToMat.createEmptyMat(extent, matType);
        populateMat.accept(mat, (Mat)voxelBuffer.buffer());
        return mat;
    }

    private static Mat fromRGBByte(Channel channelRed, Channel channelGreen, Channel channelBlue) {
        Extent extent = channelRed.extent();
        Preconditions.checkArgument((extent.z() == 1 ? 1 : 0) != 0);
        ByteBuffer out = ByteBuffer.allocate(channelRed.extent().areaXY() * 3);
        Mat mat = new Mat(extent.y(), extent.x(), CvType.CV_8UC3);
        UnsignedByteBuffer red = BufferHelper.extractByte(channelRed);
        UnsignedByteBuffer green = BufferHelper.extractByte(channelGreen);
        UnsignedByteBuffer blue = BufferHelper.extractByte(channelBlue);
        while (red.hasRemaining()) {
            out.put(blue.getRaw());
            out.put(green.getRaw());
            out.put(red.getRaw());
        }
        mat.put(0, 0, out.array());
        return mat;
    }

    private ConvertToMat() {
    }
}

