/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.feature;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.plugin.opencv.bean.feature.HOGParameters;
import org.anchoranalysis.plugin.opencv.convert.ConvertToMat;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.Mat;
import org.opencv.core.MatOfFloat;

class CalculateHOGDescriptor
extends CalculationPart<float[], FeatureInputStack> {
    private final Optional<SizeXY> resizeTo;
    private final HOGParameters parameters;

    protected float[] execute(FeatureInputStack input) throws FeatureCalculationException {
        try {
            Stack stack = this.extractStack(input.getEnergyStackRequired());
            this.checkSize(stack.extent());
            return this.extractHOGDescriptor(stack);
        }
        catch (OperationFailedException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private float[] extractHOGDescriptor(Stack stack) throws OperationFailedException {
        try {
            Mat img = ConvertToMat.fromStack(stack);
            MatOfFloat descriptorValues = new MatOfFloat();
            this.parameters.createDescriptor(stack.extent()).compute(img, descriptorValues);
            return CalculateHOGDescriptor.convertToArray(descriptorValues);
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private Stack extractStack(EnergyStack energyStack) throws OperationFailedException {
        Stack stack = energyStack.withoutParameters().asStack();
        if (this.resizeTo.isPresent()) {
            SizeXY size = this.resizeTo.get();
            return stack.mapChannel(channel -> channel.resizeXY(size.getWidth(), size.getHeight(), this.parameters.getInterpolator().voxelsResizer()));
        }
        return stack;
    }

    private void checkSize(Extent extent) throws FeatureCalculationException {
        if (extent.z() > 1) {
            throw new FeatureCalculationException("The image is 3D, but the feture only supports 2D images");
        }
        this.parameters.checkSize(extent);
    }

    private static float[] convertToArray(MatOfFloat mat) {
        float[] arr = new float[mat.rows()];
        mat.get(0, 0, arr);
        return arr;
    }

    @Generated
    public CalculateHOGDescriptor(Optional<SizeXY> resizeTo, HOGParameters parameters) {
        this.resizeTo = resizeTo;
        this.parameters = parameters;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateHOGDescriptor)) {
            return false;
        }
        CalculateHOGDescriptor other = (CalculateHOGDescriptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Optional<SizeXY> this$resizeTo = this.resizeTo;
        Optional<SizeXY> other$resizeTo = other.resizeTo;
        if (this$resizeTo == null ? other$resizeTo != null : !((Object)this$resizeTo).equals(other$resizeTo)) {
            return false;
        }
        HOGParameters this$parameters = this.parameters;
        HOGParameters other$parameters = other.parameters;
        return !(this$parameters == null ? other$parameters != null : !((Object)((Object)this$parameters)).equals((Object)other$parameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CalculateHOGDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<SizeXY> $resizeTo = this.resizeTo;
        result = result * 59 + ($resizeTo == null ? 43 : ((Object)$resizeTo).hashCode());
        HOGParameters $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)((Object)$parameters)).hashCode());
        return result;
    }
}

