/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.feature;

import java.util.function.ToIntFunction;
import lombok.Generated;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.bean.spatial.SizeXY;

class DivideUtilities {
    public static int divide(SizeXY dividend, SizeXY divisor, ToIntFunction<SizeXY> extract) {
        return extract.applyAsInt(dividend) / extract.applyAsInt(divisor);
    }

    public static void checkDivisibleBy(SizeXY biggerNumber, SizeXY divisor, String biggerText, String divisorText) throws FeatureCalculationException {
        if (!DivideUtilities.isDivisibleBy(biggerNumber.getWidth(), divisor.getWidth())) {
            throw DivideUtilities.notDivisibleException(biggerText, divisorText, "width");
        }
        if (!DivideUtilities.isDivisibleBy(biggerNumber.getHeight(), divisor.getHeight())) {
            throw DivideUtilities.notDivisibleException(biggerText, divisorText, "height");
        }
    }

    public static FeatureCalculationException notDivisibleException(String biggerText, String divisorText, String propertyText) {
        return new FeatureCalculationException(String.format("%s %s must be divisible by %s %s.", biggerText, propertyText, divisorText, propertyText));
    }

    public static int ceilDiv(double toDivide, int divisor) {
        return (int)Math.ceil(toDivide / (double)divisor);
    }

    private static boolean isDivisibleBy(int bigNumber, int divider) {
        return bigNumber % divider == 0;
    }

    @Generated
    private DivideUtilities() {
    }
}

