/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.stack;

import com.google.common.base.CharMatcher;
import java.nio.file.Path;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReaderOrientationCorrection;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.plugin.io.bean.stack.reader.RotateImageToMatchEXIFOrientation;
import org.anchoranalysis.plugin.opencv.CVInit;
import org.anchoranalysis.plugin.opencv.bean.stack.OpenCVReaderAscii;
import org.anchoranalysis.plugin.opencv.bean.stack.OpenCVReaderNonAscii;

public class OpenCVReader
extends StackReader {
    private StackReader delegateAscii = new OpenCVReaderAscii();
    private StackReader delegateNotAscii = new RotateImageToMatchEXIFOrientation((StackReaderOrientationCorrection)new OpenCVReaderNonAscii());

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        this.delegateAscii.checkMisconfigured(defaultInstances);
        this.delegateNotAscii.checkMisconfigured(defaultInstances);
    }

    public OpenedImageFile openFile(Path path, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        CVInit.blockUntilLoaded();
        String pathAsString = path.toString();
        boolean isAscii = CharMatcher.ascii().matchesAllOf((CharSequence)pathAsString);
        if (isAscii) {
            return this.delegateAscii.openFile(path, executionTimeRecorder);
        }
        return this.delegateNotAscii.openFile(path, executionTimeRecorder);
    }

    static {
        CVInit.alwaysExecuteBeforeCallingLibrary();
    }
}

