/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.stack;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.dimensions.OrientationChange;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.CalculateOrientationChange;
import org.opencv.core.Core;
import org.opencv.core.Mat;

class OrientationChanger {
    public static void changeOrientationIfNecessary(Mat image, Optional<CalculateOrientationChange> calculateOrientationChange, Logger logger) throws ImageIOException {
        OrientationChange orientationChange = OrientationChanger.calculateOrientation(calculateOrientationChange, logger);
        OrientationChanger.applyOrientationChange(image, orientationChange);
    }

    private static void applyOrientationChange(Mat image, OrientationChange orientation) throws ImageIOException {
        switch (orientation) {
            case KEEP_UNCHANGED: {
                break;
            }
            case ROTATE_90_ANTICLOCKWISE: {
                Core.rotate((Mat)image, (Mat)image, (int)0);
                break;
            }
            case ROTATE_90_CLOCKWISE: {
                Core.rotate((Mat)image, (Mat)image, (int)2);
                break;
            }
            case ROTATE_180: {
                Core.rotate((Mat)image, (Mat)image, (int)1);
                break;
            }
            case MIRROR_WITHOUT_ROTATION: {
                OrientationChanger.flipXCoordinates(image);
                break;
            }
            case ROTATE_180_MIRROR: {
                Core.rotate((Mat)image, (Mat)image, (int)1);
                OrientationChanger.flipXCoordinates(image);
                break;
            }
            case ROTATE_90_ANTICLOCKWISE_MIRROR: {
                Core.rotate((Mat)image, (Mat)image, (int)0);
                OrientationChanger.flipXCoordinates(image);
                break;
            }
            case ROTATE_90_CLOCKWISE_MIRROR: {
                Core.rotate((Mat)image, (Mat)image, (int)2);
                OrientationChanger.flipXCoordinates(image);
                break;
            }
            default: {
                throw new ImageIOException("An unsupported orientation change exists, and cannot be applied to the image: " + String.valueOf(orientation));
            }
        }
    }

    private static void flipXCoordinates(Mat image) {
        Core.flip((Mat)image, (Mat)image, (int)1);
    }

    private static OrientationChange calculateOrientation(Optional<CalculateOrientationChange> calculate, Logger logger) throws ImageIOException {
        if (calculate.isPresent()) {
            return calculate.get().calculateOrientationChange(logger);
        }
        return OrientationChange.KEEP_UNCHANGED;
    }

    @Generated
    private OrientationChanger() {
    }
}

