/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.convert;

import java.nio.FloatBuffer;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferWrap;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.Mat;

public class VoxelBufferFromMat {
    public static VoxelBuffer<?> toVoxelBuffer(Mat mat, Extent extent) throws OperationFailedException {
        if (mat.depth() == 0) {
            return VoxelBufferFromMat.unsignedByteFromMat(mat, extent);
        }
        if (mat.depth() == 2) {
            return VoxelBufferFromMat.unsignedShortFromMat(mat, extent);
        }
        if (mat.depth() == 5) {
            return VoxelBufferFromMat.floatFromMat(mat, extent);
        }
        throw new OperationFailedException("Unsupported OpenCV type: " + mat.depth());
    }

    public static VoxelBuffer<UnsignedByteBuffer> unsignedByteFromMat(Mat mat, Extent extent) {
        UnsignedByteBuffer buffer = UnsignedByteBuffer.allocate((int)extent.areaXY());
        mat.get(0, 0, buffer.array());
        return VoxelBufferWrap.unsignedByteBuffer((UnsignedByteBuffer)buffer);
    }

    public static VoxelBuffer<UnsignedShortBuffer> unsignedShortFromMat(Mat mat, Extent extent) {
        UnsignedShortBuffer buffer = UnsignedShortBuffer.allocate((int)extent.areaXY());
        mat.get(0, 0, buffer.array());
        return VoxelBufferWrap.unsignedShortBuffer((UnsignedShortBuffer)buffer);
    }

    public static VoxelBuffer<FloatBuffer> floatFromMat(Mat mat, Extent extent) {
        FloatBuffer buffer = FloatBuffer.allocate(extent.areaXY());
        mat.get(0, 0, buffer.array());
        return VoxelBufferWrap.floatBuffer((FloatBuffer)buffer);
    }

    @Generated
    private VoxelBufferFromMat() {
    }
}

