/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.convert;

import java.nio.FloatBuffer;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.plugin.opencv.convert.VoxelBufferFromMat;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.Mat;

class VoxelsFromMat {
    public static Channel toChannel(Mat mat, Extent extent) throws OperationFailedException {
        Voxels<?> voxels = VoxelsFromMat.toVoxels(mat, extent);
        return ChannelFactory.instance().create(voxels);
    }

    public static Voxels<?> toVoxels(Mat mat, Extent extent) throws OperationFailedException {
        if (mat.depth() == 0) {
            return VoxelsFromMat.unsignedByteFromMat(mat, extent);
        }
        if (mat.depth() == 2) {
            return VoxelsFromMat.unsignedShortFromMat(mat, extent);
        }
        if (mat.depth() == 5) {
            return VoxelsFromMat.floatFromMat(mat, extent);
        }
        throw new OperationFailedException("Unsupported OpenCV type: " + mat.depth());
    }

    private static Voxels<UnsignedByteBuffer> unsignedByteFromMat(Mat mat, Extent extent) {
        VoxelBuffer<UnsignedByteBuffer> buffer = VoxelBufferFromMat.unsignedByteFromMat(mat, extent);
        return VoxelsFactory.getUnsignedByte().createForVoxelBuffer(buffer, extent);
    }

    private static Voxels<UnsignedShortBuffer> unsignedShortFromMat(Mat mat, Extent extent) {
        VoxelBuffer<UnsignedShortBuffer> buffer = VoxelBufferFromMat.unsignedShortFromMat(mat, extent);
        return VoxelsFactory.getUnsignedShort().createForVoxelBuffer(buffer, extent);
    }

    private static Voxels<FloatBuffer> floatFromMat(Mat mat, Extent extent) {
        VoxelBuffer<FloatBuffer> buffer = VoxelBufferFromMat.floatFromMat(mat, extent);
        return VoxelsFactory.getFloat().createForVoxelBuffer(buffer, extent);
    }

    @Generated
    private VoxelsFromMat() {
    }
}

