/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.resizer;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.plugin.opencv.convert.ConvertToMat;
import org.anchoranalysis.plugin.opencv.convert.VoxelBufferFromMat;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class VoxelsResizerOpenCV
extends VoxelsResizer {
    public boolean canValueRangeChange() {
        return true;
    }

    protected VoxelBuffer<UnsignedByteBuffer> resizeByte(VoxelBuffer<UnsignedByteBuffer> voxelsSource, VoxelBuffer<UnsignedByteBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        Mat unscaled = ConvertToMat.fromVoxelBufferByte(voxelsSource, extentSource);
        Mat scaled = VoxelsResizerOpenCV.resize(unscaled, extentSource, extentDestination, CvType.CV_8UC1);
        return VoxelBufferFromMat.unsignedByteFromMat(scaled, extentDestination);
    }

    protected VoxelBuffer<UnsignedShortBuffer> resizeShort(VoxelBuffer<UnsignedShortBuffer> voxelsSource, VoxelBuffer<UnsignedShortBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        Mat unscaled = ConvertToMat.fromVoxelBufferShort(voxelsSource, extentSource);
        Mat scaled = VoxelsResizerOpenCV.resize(unscaled, extentSource, extentDestination, CvType.CV_16UC1);
        return VoxelBufferFromMat.unsignedShortFromMat(scaled, extentDestination);
    }

    protected VoxelBuffer<FloatBuffer> resizeFloat(VoxelBuffer<FloatBuffer> voxelsSource, VoxelBuffer<FloatBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        Mat unscaled = ConvertToMat.fromVoxelBufferFloat(voxelsSource, extentSource);
        Mat scaled = VoxelsResizerOpenCV.resize(unscaled, extentSource, extentDestination, CvType.CV_32FC1);
        return VoxelBufferFromMat.floatFromMat(scaled, extentDestination);
    }

    private static Mat resize(Mat unscaled, Extent extentSource, Extent extentDestination, int type) {
        Size size = new Size((double)extentDestination.x(), (double)extentDestination.y());
        Mat scaled = new Mat(size, type);
        Imgproc.resize((Mat)unscaled, (Mat)scaled, (Size)size, (double)0.0, (double)0.0, (int)VoxelsResizerOpenCV.selectInterpolator(extentSource, extentDestination));
        return scaled;
    }

    private static int selectInterpolator(Extent source, Extent destination) {
        if (destination.anyDimensionIsLargerThan(source)) {
            return 1;
        }
        return 3;
    }
}

