/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.feature;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.NonNegative;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.image.feature.bean.FeatureStack;
import org.anchoranalysis.image.feature.input.FeatureInputStack;
import org.anchoranalysis.plugin.opencv.CVInit;
import org.anchoranalysis.plugin.opencv.bean.feature.CalculateHOGDescriptor;
import org.anchoranalysis.plugin.opencv.bean.feature.HOGParameters;

public class HOGFeature
extends FeatureStack {
    @BeanField
    @OptionalBean
    private SizeXY resizeTo;
    @BeanField
    private HOGParameters parameters = new HOGParameters();
    @BeanField
    @NonNegative
    private int index = 0;

    public HOGFeature(SizeXY resizeTo, int index) {
        this.resizeTo = resizeTo;
        this.index = index;
    }

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.resizeTo != null && this.parameters.getWindowSize() != null) {
            if (this.resizeTo.getWidth() < this.parameters.getWindowSize().getWidth()) {
                throw new BeanMisconfiguredException("The resizeTo width is smaller than the window-width");
            }
            if (this.resizeTo.getHeight() < this.parameters.getWindowSize().getHeight()) {
                throw new BeanMisconfiguredException("The resizeTo height is smaller than the window-height");
            }
        }
    }

    public String describeParameters() {
        return Integer.toString(this.index);
    }

    protected double calculate(FeatureCalculationInput<FeatureInputStack> input) throws FeatureCalculationException {
        CVInit.blockUntilLoaded();
        float[] descriptor = (float[])input.calculate((CalculationPart)new CalculateHOGDescriptor(Optional.ofNullable(this.resizeTo), this.parameters));
        if (this.index >= descriptor.length) {
            throw new FeatureCalculationException(String.format("Index %d is out-of-bounds as the hog-descriptor has %d elements", this.index, descriptor.length));
        }
        return descriptor[this.index];
    }

    @Generated
    public HOGFeature() {
    }

    @Generated
    public SizeXY getResizeTo() {
        return this.resizeTo;
    }

    @Generated
    public void setResizeTo(SizeXY resizeTo) {
        this.resizeTo = resizeTo;
    }

    @Generated
    public HOGParameters getParameters() {
        return this.parameters;
    }

    @Generated
    public void setParameters(HOGParameters parameters) {
        this.parameters = parameters;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    static {
        CVInit.alwaysExecuteBeforeCallingLibrary();
    }
}

