/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.object.segment.stack;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.inference.bean.segment.instance.SegmentStackIntoObjectsScaleDecode;
import org.anchoranalysis.inference.InferenceModel;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.inference.concurrency.ConcurrentModel;
import org.anchoranalysis.inference.concurrency.ConcurrentModelPool;
import org.anchoranalysis.inference.concurrency.CreateModelFailedException;
import org.anchoranalysis.plugin.opencv.CVInit;
import org.anchoranalysis.plugin.opencv.convert.ConvertToMat;
import org.anchoranalysis.plugin.opencv.segment.OpenCVModel;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.dnn.Dnn;
import org.opencv.dnn.Net;

public class SegmentObjectsFromTensorFlowModel
extends SegmentStackIntoObjectsScaleDecode<Mat, OpenCVModel> {
    @BeanField
    private String modelBinaryPath;
    @BeanField
    @AllowEmpty
    private String modelTextGraphPath = "";

    public ConcurrentModelPool<OpenCVModel> createModelPool(ConcurrencyPlan plan, Logger logger) throws CreateModelFailedException {
        if (plan.numberGPUs() > 0) {
            logger.messageLogger().logFormatted("Although the plan allows for %d GPU processors, GPU processers are disabled with the OpenCV processor.", new Object[]{plan.numberGPUs()});
        }
        return new ConcurrentModelPool(plan.disableGPUs(), this::readPrepareModel, logger);
    }

    protected Mat deriveInput(Stack stack, Optional<double[]> subtractMeans) throws OperationFailedException {
        double[] toSubtract = subtractMeans.orElseGet(() -> SegmentObjectsFromTensorFlowModel.arrayWithZeros(stack.getNumberChannels()));
        try {
            Mat mat = ConvertToMat.makeRGBStack(stack, false);
            return Dnn.blobFromImage((Mat)mat, (double)1.0, (Size)mat.size(), (Scalar)new Scalar(toSubtract), (boolean)false, (boolean)false);
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    protected Optional<String> inputName() {
        return Optional.empty();
    }

    private Optional<ConcurrentModel<OpenCVModel>> readPrepareModel(boolean useGPU) throws CreateModelFailedException {
        try {
            Path model = this.resolve(this.modelBinaryPath);
            SegmentObjectsFromTensorFlowModel segmentObjectsFromTensorFlowModel = this;
            Optional textGraph = OptionalUtilities.map((Optional)OptionalFactory.create((String)this.modelTextGraphPath), x$0 -> segmentObjectsFromTensorFlowModel.resolve((String)x$0));
            CVInit.blockUntilLoaded();
            Net net = SegmentObjectsFromTensorFlowModel.readNet(model, textGraph);
            if (useGPU) {
                net.setPreferableBackend(5);
                net.setPreferableTarget(6);
            }
            return Optional.of(new ConcurrentModel((InferenceModel)new OpenCVModel(net), useGPU));
        }
        catch (InitializeException e) {
            throw new CreateModelFailedException((Throwable)e);
        }
    }

    private static Net readNet(Path model, Optional<Path> textGraph) {
        if (textGraph.isPresent()) {
            return Dnn.readNetFromTensorflow((String)SegmentObjectsFromTensorFlowModel.absolutePath(model), (String)SegmentObjectsFromTensorFlowModel.absolutePath(textGraph.get()));
        }
        return Dnn.readNetFromTensorflow((String)SegmentObjectsFromTensorFlowModel.absolutePath(model));
    }

    private static String absolutePath(Path path) {
        return path.toAbsolutePath().toString();
    }

    private static double[] arrayWithZeros(int size) {
        return new double[size];
    }

    @Generated
    public String getModelBinaryPath() {
        return this.modelBinaryPath;
    }

    @Generated
    public void setModelBinaryPath(String modelBinaryPath) {
        this.modelBinaryPath = modelBinaryPath;
    }

    @Generated
    public String getModelTextGraphPath() {
        return this.modelTextGraphPath;
    }

    @Generated
    public void setModelTextGraphPath(String modelTextGraphPath) {
        this.modelTextGraphPath = modelTextGraphPath;
    }

    static {
        CVInit.alwaysExecuteBeforeCallingLibrary();
    }
}

