/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.bean.stack;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.reader.StackReaderOrientationCorrection;
import org.anchoranalysis.image.io.stack.CalculateOrientationChange;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;
import org.anchoranalysis.plugin.opencv.bean.stack.OpenedRasterOpenCV;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.imgcodecs.Imgcodecs;

class OpenCVReaderNonAscii
extends StackReaderOrientationCorrection {
    private static final String EXECUTION_TIME_PREFIX = "OpenCV Non-ASCII: ";

    OpenCVReaderNonAscii() {
    }

    public OpenedImageFile openFile(Path path, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        return new OpenedRasterOpenCV(path, executionTimeRecorder, Optional.empty(), EXECUTION_TIME_PREFIX, (CheckedFunction<Path, Mat, IOException>)((CheckedFunction)OpenCVReaderNonAscii::readDecodeMat));
    }

    public OpenedImageFile openFile(Path path, CalculateOrientationChange orientationCorrection, ExecutionTimeRecorder executionTimeRecorder) throws ImageIOException {
        return new OpenedRasterOpenCV(path, executionTimeRecorder, Optional.of(orientationCorrection), EXECUTION_TIME_PREFIX, (CheckedFunction<Path, Mat, IOException>)((CheckedFunction)OpenCVReaderNonAscii::readDecodeMat));
    }

    private static Mat readDecodeMat(Path path) throws IOException {
        byte[] bytes = Files.readAllBytes(path);
        MatOfByte mat = new MatOfByte(bytes);
        return Imgcodecs.imdecode((Mat)mat, (int)-1);
    }
}

