/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.opencv.convert;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.plugin.opencv.convert.VoxelsFromMat;
import org.anchoranalysis.spatial.box.Extent;
import org.opencv.core.Core;
import org.opencv.core.Mat;

class VoxelsRGBFromMat {
    public static Stack matToRGB(Mat mat, Extent extent) throws OperationFailedException {
        Preconditions.checkArgument((extent.z() == 1 ? 1 : 0) != 0);
        ArrayList split = new ArrayList(3);
        Core.split((Mat)mat, split);
        try {
            return new Stack(true, new Channel[]{VoxelsFromMat.toChannel((Mat)split.get(2), extent), VoxelsFromMat.toChannel((Mat)split.get(1), extent), VoxelsFromMat.toChannel((Mat)split.get(0), extent)});
        }
        catch (IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
        catch (CreateException e) {
            throw new OperationFailedException("Unable to create a stack from the the three extacted channels", (Throwable)e);
        }
    }

    @Generated
    private VoxelsRGBFromMat() {
    }
}

