/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.mark.factory.MarkFactory;
import org.anchoranalysis.mpp.bean.provider.MarkCollectionProvider;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.MarkCollection;
import org.anchoranalysis.plugin.points.bean.fitter.PointsFitterToMark;
import org.anchoranalysis.plugin.points.convexhull.ConvexHullUtilities;
import org.anchoranalysis.spatial.point.Point2i;
import org.anchoranalysis.spatial.point.Point3f;
import org.anchoranalysis.spatial.point.PointConverter;

public class FitPointsFromObjects
extends MarkCollectionProvider {
    @BeanField
    private PointsFitterToMark pointsFitter;
    @BeanField
    private MarkFactory markFactory;
    @BeanField
    private boolean convexHull = true;
    @BeanField
    private boolean ignoreFittingFailure = true;

    public MarkCollection get() throws ProvisionFailedException {
        try {
            Dimensions dimensions = this.pointsFitter.createDim();
            return new MarkCollection(this.pointsFitter.createObjects().stream().mapToListOptional(object -> this.createMarkFromObject((ObjectMask)object, dimensions)));
        }
        catch (ProvisionFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private Optional<Mark> createMarkFromObject(ObjectMask object, Dimensions dimensions) throws ProvisionFailedException {
        try {
            List<Point2i> points = this.maybeApplyConvexHull(object);
            if (points.isEmpty()) {
                return this.handleFittingFailure("There are 0 points to fit with.");
            }
            return this.fitToMark(PointConverter.convert2iTo3f(points), dimensions);
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private List<Point2i> maybeApplyConvexHull(ObjectMask object) throws OperationFailedException {
        try {
            List<Point2i> points = ConvexHullUtilities.pointsOnOutline(object);
            if (this.convexHull) {
                return ConvexHullUtilities.convexHull2D(points, this.pointsFitter.getMinNumPoints());
            }
            return points;
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private Optional<Mark> fitToMark(List<Point3f> pointsToFit, Dimensions dimensions) throws ProvisionFailedException {
        Mark markOut = this.markFactory.create();
        try {
            this.pointsFitter.fitPointsToMark(pointsToFit, markOut, dimensions);
            return Optional.of(markOut);
        }
        catch (OperationFailedException e) {
            return this.handleFittingFailure(e.friendlyMessage());
        }
    }

    private Optional<Mark> handleFittingFailure(String errorMessage) throws ProvisionFailedException {
        if (this.ignoreFittingFailure) {
            this.getLogger().messageLogger().logFormatted("Ignoring mark due to a fitting error. %s", new Object[]{errorMessage});
            return Optional.empty();
        }
        throw new ProvisionFailedException(String.format("Cannot create mark from points due to fitting error.%n%s", errorMessage));
    }

    public PointsFitterToMark getPointsFitter() {
        return this.pointsFitter;
    }

    public void setPointsFitter(PointsFitterToMark pointsFitter) {
        this.pointsFitter = pointsFitter;
    }

    public MarkFactory getMarkFactory() {
        return this.markFactory;
    }

    public void setMarkFactory(MarkFactory markFactory) {
        this.markFactory = markFactory;
    }

    public boolean isConvexHull() {
        return this.convexHull;
    }

    public void setConvexHull(boolean convexHull) {
        this.convexHull = convexHull;
    }

    public boolean isIgnoreFittingFailure() {
        return this.ignoreFittingFailure;
    }

    public void setIgnoreFittingFailure(boolean ignoreFittingFailure) {
        this.ignoreFittingFailure = ignoreFittingFailure;
    }
}

