/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.linalg.Algebra;
import cern.jet.math.Functions;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.spatial.point.Point2d;

public class EllipseStandardFormConverter {
    private DoubleMatrix1D matrix;
    private double k1;
    private double k2;
    private double axisMajor;
    private double axisMinor;
    private DoubleMatrix1D directionMinor;
    private DoubleMatrix1D directionMajor;

    public EllipseStandardFormConverter(DoubleMatrix1D matrix) throws CreateException {
        this.matrix = matrix;
        this.convert();
    }

    private void convert() throws CreateException {
        double a11 = this.matrix.get(0);
        double a12 = this.matrix.get(1) / 2.0;
        double a22 = this.matrix.get(2);
        double b1 = this.matrix.get(3);
        double b2 = this.matrix.get(4);
        double c = this.matrix.get(5);
        if (a11 * a22 - Math.pow(a12, 2.0) <= 0.0) {
            throw new CreateException("Not an ellipse");
        }
        double kdem = 2.0 * (Math.pow(a12, 2.0) - a11 * a22);
        assert (kdem != 0.0);
        this.k1 = (a22 * b1 - a12 * b2) / kdem;
        this.k2 = (a11 * b2 - a12 * b1) / kdem;
        double mu = 1.0 / (a11 * Math.pow(this.k1, 2.0) + 2.0 * a12 * this.k1 * this.k2 + a22 * Math.pow(this.k2, 2.0) - c);
        double m11 = mu * a11;
        double m12 = mu * a12;
        double m22 = mu * a22;
        double lambdaCommon = Math.pow(Math.pow(m11 - m22, 2.0) + 4.0 * Math.pow(m12, 2.0), 0.5);
        double lambda1 = (m11 + m22 + lambdaCommon) / 2.0;
        this.axisMinor = Math.pow(lambda1, -0.5);
        double lambda2 = (m11 + m22 - lambdaCommon) / 2.0;
        this.axisMajor = Math.pow(lambda2, -0.5);
        this.directionMinor = DoubleFactory1D.dense.make(2);
        if (m11 >= m22) {
            this.directionMinor.set(0, lambda1 - m22);
            this.directionMinor.set(1, m12);
        } else {
            this.directionMinor.set(0, m12);
            this.directionMinor.set(1, lambda1 - m11);
        }
        Algebra a = new Algebra();
        Functions F = Functions.functions;
        double directionMinorNorm = Math.pow(a.norm2(this.directionMinor), 0.5);
        this.directionMinor.assign(Functions.div((double)directionMinorNorm));
        this.directionMajor = DoubleFactory1D.dense.make(2);
        this.directionMajor.set(0, -1.0 * this.directionMinor.get(1));
        this.directionMajor.set(1, this.directionMinor.get(0));
    }

    public double getCenterPointX() {
        return this.k1;
    }

    public double getCenterPointY() {
        return this.k2;
    }

    public Point2d centerPoint() {
        return new Point2d(this.k1, this.k2);
    }

    public double getSemiMajorAxis() {
        return this.axisMajor;
    }

    public double getSemiMinorAxis() {
        return this.axisMinor;
    }

    public double getMajorAxisAngle() {
        return EllipseStandardFormConverter.atanHandlingNan(this.getMajorAxisSlope());
    }

    public double getMinorAxisAngle() {
        return EllipseStandardFormConverter.atanHandlingNan(this.getMajorAxisSlope());
    }

    public static double atanHandlingNan(double val) {
        if (Double.isNaN(val)) {
            return 1.5707963267948966;
        }
        return Math.atan(val);
    }

    public double getMajorAxisSlope() {
        return this.directionMajor.get(1) / this.directionMajor.get(0);
    }

    public double getMinorAxisSlope() {
        return this.directionMinor.get(1) / this.directionMinor.get(0);
    }
}

