/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import cern.colt.matrix.DoubleMatrix2D;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.conic.Ellipsoid;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.OrientationRotationMatrix;
import org.anchoranalysis.spatial.orientation.RotationMatrix;
import org.anchoranalysis.spatial.point.Point3d;

public class FitResult {
    private Point3d centerPoint;
    private double radiusX;
    private double radiusY;
    private double radiusZ;
    private DoubleMatrix2D rotMatrix;

    public void applyFitResultToMark(Ellipsoid mark, Dimensions sceneDim, double shell) throws PointsFitterException {
        OrientationRotationMatrix orientation = new OrientationRotationMatrix(new RotationMatrix(this.rotMatrix));
        mark.setShell(shell);
        mark.setMarksExplicit(this.centerPoint, (Orientation)orientation, this.radiiAsPoint());
        BoundingBox box = mark.boxAllRegions(sceneDim);
        if (box.extent().x() < 1 || box.extent().y() < 1 || box.extent().z() < 1) {
            throw new PointsFitterException("Ellipsoid is outside scene");
        }
    }

    public void applyRadiiSubtractScale(double subtract, double scale) {
        this.radiusX = (this.radiusX - subtract) * scale;
        this.radiusY = (this.radiusY - subtract) * scale;
        this.radiusZ = (this.radiusZ - subtract) * scale;
    }

    public void imposeMinimumRadius(double minRadius) {
        this.radiusX = Math.max(this.radiusX, minRadius);
        this.radiusY = Math.max(this.radiusY, minRadius);
        this.radiusZ = Math.max(this.radiusZ, minRadius);
    }

    private Point3d radiiAsPoint() {
        return new Point3d(this.radiusX, this.radiusY, this.radiusZ);
    }

    public Point3d getCenterPoint() {
        return this.centerPoint;
    }

    public double getRadiusX() {
        return this.radiusX;
    }

    public double getRadiusY() {
        return this.radiusY;
    }

    public double getRadiusZ() {
        return this.radiusZ;
    }

    public DoubleMatrix2D getRotMatrix() {
        return this.rotMatrix;
    }

    public void setCenterPoint(Point3d centerPoint) {
        this.centerPoint = centerPoint;
    }

    public void setRadiusX(double radiusX) {
        this.radiusX = radiusX;
    }

    public void setRadiusY(double radiusY) {
        this.radiusY = radiusY;
    }

    public void setRadiusZ(double radiusZ) {
        this.radiusZ = radiusZ;
    }

    public void setRotMatrix(DoubleMatrix2D rotMatrix) {
        this.rotMatrix = rotMatrix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FitResult)) {
            return false;
        }
        FitResult other = (FitResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getRadiusX(), other.getRadiusX()) != 0) {
            return false;
        }
        if (Double.compare(this.getRadiusY(), other.getRadiusY()) != 0) {
            return false;
        }
        if (Double.compare(this.getRadiusZ(), other.getRadiusZ()) != 0) {
            return false;
        }
        Point3d this$centerPoint = this.getCenterPoint();
        Point3d other$centerPoint = other.getCenterPoint();
        if (this$centerPoint == null ? other$centerPoint != null : !this$centerPoint.equals(other$centerPoint)) {
            return false;
        }
        DoubleMatrix2D this$rotMatrix = this.getRotMatrix();
        DoubleMatrix2D other$rotMatrix = other.getRotMatrix();
        return !(this$rotMatrix == null ? other$rotMatrix != null : !this$rotMatrix.equals(other$rotMatrix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FitResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $radiusX = Double.doubleToLongBits(this.getRadiusX());
        result = result * 59 + (int)($radiusX >>> 32 ^ $radiusX);
        long $radiusY = Double.doubleToLongBits(this.getRadiusY());
        result = result * 59 + (int)($radiusY >>> 32 ^ $radiusY);
        long $radiusZ = Double.doubleToLongBits(this.getRadiusZ());
        result = result * 59 + (int)($radiusZ >>> 32 ^ $radiusZ);
        Point3d $centerPoint = this.getCenterPoint();
        result = result * 59 + ($centerPoint == null ? 43 : $centerPoint.hashCode());
        DoubleMatrix2D $rotMatrix = this.getRotMatrix();
        result = result * 59 + ($rotMatrix == null ? 43 : $rotMatrix.hashCode());
        return result;
    }

    public String toString() {
        return "FitResult(centerPoint=" + this.getCenterPoint() + ", radiusX=" + this.getRadiusX() + ", radiusY=" + this.getRadiusY() + ", radiusZ=" + this.getRadiusZ() + ", rotMatrix=" + this.getRotMatrix() + ")";
    }
}

