/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import georegression.fitting.ellipse.FitEllipseAlgebraic;
import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseQuadratic_F64;
import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.conic.Ellipse;
import org.anchoranalysis.plugin.points.bean.fitter.ConicFitterBase;
import org.anchoranalysis.plugin.points.bean.fitter.EllipseStandardFormConverter;
import org.anchoranalysis.spatial.orientation.Orientation;
import org.anchoranalysis.spatial.orientation.Orientation2D;
import org.anchoranalysis.spatial.point.Point2d;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3f;

public class LinearLeastSquaresEllipseFitter
extends ConicFitterBase {
    @BeanField
    private double minRadius = 0.55;

    public void fit(List<Point3f> points, Mark mark, Dimensions dimensions) throws PointsFitterException, InsufficientPointsException {
        List pointsConvert = FunctionalList.mapToList(points, point -> new Point2D_F64((double)point.x(), (double)point.y()));
        FitEllipseAlgebraic fitter = new FitEllipseAlgebraic();
        fitter.process(pointsConvert);
        EllipseQuadratic_F64 fittedResult = fitter.getEllipse();
        if (!fittedResult.isEllipse()) {
            throw new InsufficientPointsException(String.format("Insufficient number of points for an ellipse-fit. There were %d points.", points.size()));
        }
        this.applyCoefficientsToMark(fittedResult, mark);
    }

    private void applyCoefficientsToMark(EllipseQuadratic_F64 fittedResult, Mark mark) throws PointsFitterException {
        DoubleMatrix1D coefficients = DoubleFactory1D.dense.make(6);
        coefficients.set(0, fittedResult.a);
        coefficients.set(1, fittedResult.b * 2.0);
        coefficients.set(2, fittedResult.c);
        coefficients.set(3, fittedResult.d * 2.0);
        coefficients.set(4, fittedResult.e * 2.0);
        coefficients.set(5, fittedResult.f);
        try {
            EllipseStandardFormConverter converter = new EllipseStandardFormConverter(coefficients);
            this.applyToMark((Ellipse)mark, converter);
        }
        catch (CreateException e) {
            throw new PointsFitterException((Exception)((Object)e));
        }
    }

    private void applyToMark(Ellipse markE, EllipseStandardFormConverter converter) throws PointsFitterException {
        assert (!Double.isNaN(converter.getMajorAxisAngle()));
        double radiusX = converter.getSemiMajorAxis() - this.getSubtractRadii();
        double radiusY = converter.getSemiMinorAxis() - this.getSubtractRadii();
        if (radiusX <= 0.0 || radiusY <= 0.0) {
            throw new PointsFitterException("fitter returned 0 width or height");
        }
        markE.setShell(this.getShell());
        markE.setMarksExplicit(new Point3d(converter.getCenterPointX(), converter.getCenterPointY(), 0.0), (Orientation)new Orientation2D(converter.getMajorAxisAngle()), new Point2d(radiusX, radiusY));
    }

    public boolean isCompatibleWith(Mark testMark) {
        return testMark instanceof Ellipse;
    }

    public double getMinRadius() {
        return this.minRadius;
    }

    public void setMinRadius(double minRadius) {
        this.minRadius = minRadius;
    }
}

