/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.DimensionsProvider;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.mpp.bean.points.PointsBean;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitter;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.spatial.point.Point3f;

public class PointsFitterToMark
extends PointsBean<PointsFitterToMark> {
    @BeanField
    private PointsFitter pointsFitter;
    @BeanField
    private DimensionsProvider dimensions;
    @BeanField
    @Positive
    private int minNumPoints = 1;
    @BeanField
    private ObjectCollectionProvider objects;

    public void fitPointsToMark(List<Point3f> pointsForFitter, Mark mark, Dimensions dim) throws OperationFailedException {
        try {
            this.pointsFitter.fit(pointsForFitter, mark, dim);
        }
        catch (InsufficientPointsException | PointsFitterException e) {
            throw new OperationFailedException(e);
        }
    }

    public ObjectCollection createObjects() throws ProvisionFailedException {
        return (ObjectCollection)this.objects.get();
    }

    public Dimensions createDim() throws ProvisionFailedException {
        return (Dimensions)this.dimensions.get();
    }

    public PointsFitter getPointsFitter() {
        return this.pointsFitter;
    }

    public void setPointsFitter(PointsFitter pointsFitter) {
        this.pointsFitter = pointsFitter;
    }

    public DimensionsProvider getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(DimensionsProvider dimensions) {
        this.dimensions = dimensions;
    }

    public int getMinNumPoints() {
        return this.minNumPoints;
    }

    public void setMinNumPoints(int minNumPoints) {
        this.minNumPoints = minNumPoints;
    }

    public ObjectCollectionProvider getObjects() {
        return this.objects;
    }

    public void setObjects(ObjectCollectionProvider objects) {
        this.objects = objects;
    }
}

