/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.calculate.ellipse;

import java.util.List;
import java.util.Set;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.points.PointsFromObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.conic.Ellipse;
import org.anchoranalysis.plugin.points.bean.fitter.ConicFitterBase;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;

class EllipseFactory {
    private static final int MIN_NUMBER_POINTS = 10;
    private final ConicFitterBase pointsFitter;

    public Ellipse create(ObjectMask object, Dimensions dimensions, double shell) throws CreateException, InsufficientPointsException {
        this.pointsFitter.setShell(shell);
        Set points = PointsFromObject.setFromContour((ObjectMask)object);
        if (points.size() < 10) {
            throw new InsufficientPointsException(String.format("Only %d points. There must be at least %d points.", points.size(), 10));
        }
        return this.createEllipse(points, dimensions);
    }

    private Ellipse createEllipse(Set<Point3i> points, Dimensions dim) throws InsufficientPointsException, CreateException {
        Ellipse mark = new Ellipse();
        List pointsAsFloat = FunctionalList.mapToList(points, PointConverter::floatFromIntDropZ);
        try {
            this.pointsFitter.fit(pointsAsFloat, (Mark)mark, dim);
        }
        catch (PointsFitterException e) {
            throw new CreateException((Throwable)e);
        }
        return mark;
    }

    public EllipseFactory(ConicFitterBase pointsFitter) {
        this.pointsFitter = pointsFitter;
    }
}

