/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.calculate.ellipsoid;

import java.util.List;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.cache.part.ResolvedPart;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.mpp.mark.conic.Ellipsoid;
import org.anchoranalysis.plugin.points.calculate.ellipsoid.CalculatePointsFromOutline;
import org.anchoranalysis.plugin.points.calculate.ellipsoid.EllipsoidFactory;
import org.anchoranalysis.spatial.point.Point3i;

public class CalculateEllipsoidLeastSquares
extends CalculationPart<Ellipsoid, FeatureInputSingleObject> {
    private final boolean suppressZCovariance;
    private final ResolvedPart<List<Point3i>, FeatureInputSingleObject> resolved;

    public static Ellipsoid of(FeatureCalculationInput<FeatureInputSingleObject> input, boolean suppressZCovariance) throws FeatureCalculationException {
        ResolvedPart ccPoints = input.resolver().search((CalculationPart)new CalculatePointsFromOutline());
        ResolvedPart ccEllipsoid = input.resolver().search((CalculationPart)new CalculateEllipsoidLeastSquares(suppressZCovariance, (ResolvedPart<List<Point3i>, FeatureInputSingleObject>)ccPoints));
        return (Ellipsoid)input.calculate(ccEllipsoid);
    }

    protected Ellipsoid execute(FeatureInputSingleObject input) throws FeatureCalculationException {
        try {
            return EllipsoidFactory.createMarkEllipsoidLeastSquares((CheckedSupplier<List<Point3i>, CreateException>)((CheckedSupplier)() -> {
                try {
                    return (List)this.resolved.getOrCalculate((FeatureInput)input);
                }
                catch (FeatureCalculationException e) {
                    throw new CreateException((Throwable)e);
                }
            }), input.dimensionsRequired(), this.suppressZCovariance, 0.2);
        }
        catch (CreateException e) {
            throw new FeatureCalculationException((Throwable)e);
        }
    }

    private CalculateEllipsoidLeastSquares(boolean suppressZCovariance, ResolvedPart<List<Point3i>, FeatureInputSingleObject> resolved) {
        this.suppressZCovariance = suppressZCovariance;
        this.resolved = resolved;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalculateEllipsoidLeastSquares)) {
            return false;
        }
        CalculateEllipsoidLeastSquares other = (CalculateEllipsoidLeastSquares)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.suppressZCovariance != other.suppressZCovariance) {
            return false;
        }
        ResolvedPart<List<Point3i>, FeatureInputSingleObject> this$resolved = this.resolved;
        ResolvedPart<List<Point3i>, FeatureInputSingleObject> other$resolved = other.resolved;
        return !(this$resolved == null ? other$resolved != null : !this$resolved.equals(other$resolved));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CalculateEllipsoidLeastSquares;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.suppressZCovariance ? 79 : 97);
        ResolvedPart<List<Point3i>, FeatureInputSingleObject> $resolved = this.resolved;
        result = result * 59 + ($resolved == null ? 43 : $resolved.hashCode());
        return result;
    }
}

