/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.calculate.ellipsoid;

import java.util.Collection;
import java.util.List;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.functional.checked.CheckedSupplier;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.points.PointsFromObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.conic.Ellipsoid;
import org.anchoranalysis.plugin.points.bean.fitter.LinearLeastSquaresEllipsoidFitter;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;

public class EllipsoidFactory {
    public static Ellipsoid createMarkEllipsoidLeastSquares(ObjectMask object, Dimensions dimensions, boolean suppressZCovariance, double shell) throws CreateException {
        return EllipsoidFactory.createMarkEllipsoidLeastSquares((CheckedSupplier<List<Point3i>, CreateException>)((CheckedSupplier)() -> PointsFromObject.listFromOutline3i((ObjectMask)object)), dimensions, suppressZCovariance, shell);
    }

    public static Ellipsoid createMarkEllipsoidLeastSquares(CheckedSupplier<List<Point3i>, CreateException> opPoints, Dimensions dimensions, boolean suppressZCovariance, double shell) throws CreateException {
        LinearLeastSquaresEllipsoidFitter pointsFitter = new LinearLeastSquaresEllipsoidFitter();
        pointsFitter.setShell(shell);
        pointsFitter.setSuppressZCovariance(suppressZCovariance);
        Ellipsoid mark = new Ellipsoid();
        List pointsFloat = FunctionalList.mapToList((Collection)((Collection)opPoints.get()), PointConverter::floatFromInt);
        try {
            pointsFitter.fit(pointsFloat, (Mark)mark, dimensions);
        }
        catch (PointsFitterException e) {
            throw new CreateException((Throwable)e);
        }
        return mark;
    }

    private EllipsoidFactory() {
    }
}

