/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.convexhull;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.points.PointsFromObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.point.Point2i;

public class ConvexHullUtilities {
    private static final int DEFAULT_MIN_NUM_POINTS = 5;

    public static List<Point2i> convexHull2D(List<Point2i> points) throws OperationFailedException {
        return ConvexHullUtilities.convexHull2D(points, 5);
    }

    public static List<Point2i> convexHull2D(List<Point2i> points, int minNumberPoints) throws OperationFailedException {
        if (points.size() >= minNumberPoints) {
            List<Point2i> filtered = ConvexHullUtilities.filterPointsGiftWrap(points);
            if (!filtered.isEmpty()) {
                return filtered;
            }
            return points;
        }
        return points;
    }

    public static List<Point2i> pointsOnAllOutlines(ObjectCollection objects) {
        return PointsFromObject.listFromAllOutlines2i((ObjectCollection)objects);
    }

    public static List<Point2i> pointsOnOutline(ObjectMask object) throws CreateException {
        return PointsFromObject.listFromOutline2i((ObjectMask)object);
    }

    private static List<Point2i> filterPointsGiftWrap(List<Point2i> points) throws OperationFailedException {
        int p2;
        int p1;
        int xbase = 0;
        int ybase = 0;
        int[] xx = new int[points.size()];
        int[] yy = new int[points.size()];
        int n2 = 0;
        int pstart = p1 = ConvexHullUtilities.calculateStartingIndex(points);
        int count = 0;
        do {
            int x1 = points.get(p1).x();
            int y1 = points.get(p1).y();
            p2 = p1 + 1;
            if (p2 == points.size()) {
                p2 = 0;
            }
            int x2 = points.get(p2).x();
            int y2 = points.get(p2).y();
            int p3 = p2 + 1;
            if (p3 == points.size()) {
                p3 = 0;
            }
            do {
                int x3 = points.get(p3).x();
                int y3 = points.get(p3).y();
                int determinate = x1 * (y2 - y3) - y1 * (x2 - x3) + (y3 * x2 - y2 * x3);
                if (determinate > 0) {
                    x2 = x3;
                    y2 = y3;
                    p2 = p3;
                }
                if (++p3 != points.size()) continue;
                p3 = 0;
            } while (p3 != p1);
            if (n2 < points.size()) {
                xx[n2] = xbase + x1;
                yy[n2] = ybase + y1;
                ++n2;
                continue;
            }
            if (++count <= 10) continue;
            throw new OperationFailedException("Count variable is too high, cannot calculate convex-hull");
        } while ((p1 = p2) != pstart);
        return ConvexHullUtilities.createPointsList(n2, xx, yy);
    }

    private static List<Point2i> createPointsList(int numPoints, int[] xx, int[] yy) {
        return IntStream.range(0, numPoints).mapToObj(index -> new Point2i(xx[index], yy[index])).collect(Collectors.toList());
    }

    private static int calculateStartingIndex(List<Point2i> pointsIn) {
        int y;
        int smallestY = Integer.MAX_VALUE;
        for (int i = 0; i < pointsIn.size(); ++i) {
            y = pointsIn.get(i).y();
            if (y >= smallestY) continue;
            smallestY = y;
        }
        int smallestX = Integer.MAX_VALUE;
        int p1 = 0;
        for (int i = 0; i < pointsIn.size(); ++i) {
            int x = pointsIn.get(i).x();
            y = pointsIn.get(i).y();
            if (y != smallestY || x >= smallestX) continue;
            smallestX = x;
            p1 = i;
        }
        return p1;
    }

    private ConvexHullUtilities() {
    }
}

