/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitter;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.bean.proposer.MarkProposer;
import org.anchoranalysis.mpp.bean.proposer.PointsProposer;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.voxelized.memo.VoxelizedMarkMemo;
import org.anchoranalysis.mpp.proposer.ProposalAbnormalFailureException;
import org.anchoranalysis.mpp.proposer.ProposerContext;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.PointConverter;

public class FitPoints
extends MarkProposer {
    @BeanField
    private PointsProposer pointsProposer;
    @BeanField
    private PointsFitter pointsFitter;
    @BeanField
    private boolean reportFitterErrors = true;
    private Logger logger;

    public boolean isCompatibleWith(Mark testMark) {
        return this.pointsFitter.isCompatibleWith(testMark) && this.pointsProposer.isCompatibleWith(testMark);
    }

    public boolean propose(VoxelizedMarkMemo inputMark, ProposerContext context) throws ProposalAbnormalFailureException {
        inputMark.reset();
        Point3d point = inputMark.getMark().centerPoint();
        try {
            Optional points = this.pointsProposer.propose(point, inputMark.getMark(), context.dimensions(), context.getRandomNumberGenerator(), context.getErrorNode().add("pointsProposer"));
            if (!points.isPresent()) {
                return false;
            }
            List fitList = FunctionalList.mapToList((Collection)((Collection)points.get()), PointConverter::floatFromInt);
            this.pointsFitter.fit(fitList, inputMark.getMark(), context.dimensions());
        }
        catch (InsufficientPointsException | PointsFitterException e) {
            if (this.reportFitterErrors) {
                this.getLogger().errorReporter().recordError(FitPoints.class, e);
            }
            context.getErrorNode().add(e.toString());
            return false;
        }
        return true;
    }

    @Generated
    public PointsProposer getPointsProposer() {
        return this.pointsProposer;
    }

    @Generated
    public void setPointsProposer(PointsProposer pointsProposer) {
        this.pointsProposer = pointsProposer;
    }

    @Generated
    public PointsFitter getPointsFitter() {
        return this.pointsFitter;
    }

    @Generated
    public void setPointsFitter(PointsFitter pointsFitter) {
        this.pointsFitter = pointsFitter;
    }

    @Generated
    public boolean isReportFitterErrors() {
        return this.reportFitterErrors;
    }

    @Generated
    public void setReportFitterErrors(boolean reportFitterErrors) {
        this.reportFitterErrors = reportFitterErrors;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }
}

