/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean;

import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProviderUnary;
import org.anchoranalysis.image.core.object.ObjectFromPointsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.points.bean.SplitContourSmoothingSpline;
import org.anchoranalysis.spatial.point.Contour;
import org.anchoranalysis.spatial.point.PointConverter;

public class SplitContourAtSaddlePoints
extends ObjectCollectionProviderUnary {
    @BeanField
    private double smoothingFactor = 0.001;
    @BeanField
    private int numberLoopPoints = 0;
    @BeanField
    private int minNumberPoints = 10;

    public ObjectCollection createFromObjects(ObjectCollection objects) throws ProvisionFailedException {
        return objects.stream().flatMap(CreateException.class, this::splitContoursFromObject);
    }

    private ObjectCollection splitContoursFromObject(ObjectMask object) throws ProvisionFailedException {
        if (object.boundingBox().extent().z() > 1) {
            throw new ProvisionFailedException("Only objects with z-slices > 1 are allowed");
        }
        try {
            return SplitContourAtSaddlePoints.contoursAsObjects(SplitContourSmoothingSpline.apply(object, this.smoothingFactor, this.numberLoopPoints, this.minNumberPoints));
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static ObjectCollection contoursAsObjects(List<Contour> contourList) throws OperationFailedException {
        try {
            return ObjectCollectionFactory.mapFrom(contourList, CreateException.class, contour -> SplitContourAtSaddlePoints.createObjectFromContour(contour, true));
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static ObjectMask createObjectFromContour(Contour contour, boolean round) throws CreateException {
        return ObjectFromPointsFactory.create((Collection)PointConverter.convert3i((List)contour.getPoints(), (boolean)round));
    }

    @Generated
    public double getSmoothingFactor() {
        return this.smoothingFactor;
    }

    @Generated
    public void setSmoothingFactor(double smoothingFactor) {
        this.smoothingFactor = smoothingFactor;
    }

    @Generated
    public int getNumberLoopPoints() {
        return this.numberLoopPoints;
    }

    @Generated
    public void setNumberLoopPoints(int numberLoopPoints) {
        this.numberLoopPoints = numberLoopPoints;
    }

    @Generated
    public int getMinNumberPoints() {
        return this.minNumberPoints;
    }

    @Generated
    public void setMinNumberPoints(int minNumberPoints) {
        this.minNumberPoints = minNumberPoints;
    }
}

