/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean;

import java.util.ArrayList;
import java.util.List;
import java.util.function.ToIntFunction;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.opencv.CVFindContours;
import org.anchoranalysis.spatial.point.Contour;
import org.anchoranalysis.spatial.point.Point3f;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.Tuple3i;
import umontreal.ssj.functionfit.SmoothingCubicSpline;

class SplitContourSmoothingSpline {
    public static List<Contour> apply(ObjectMask object, double rho, int numberLoopPoints, int minimumNumberPoints) throws OperationFailedException {
        return SplitContourSmoothingSpline.traversePointsAndCallFitter(object, minimumNumberPoints, (pts, out) -> SplitContourSmoothingSpline.fitSplinesAndExtract(pts, rho, pts, numberLoopPoints, out));
    }

    private static List<Contour> traversePointsAndCallFitter(ObjectMask object, int minimumNumberPoints, FitSplinesExtract fitter) throws OperationFailedException {
        List contoursTraversed = CVFindContours.contoursForObject((ObjectMask)object);
        ArrayList<Contour> out = new ArrayList<Contour>();
        for (Contour contour : contoursTraversed) {
            SplitContourSmoothingSpline.addSplinesFor(contour, out, fitter, minimumNumberPoints);
        }
        return out;
    }

    private static void addSplinesFor(Contour contourIn, List<Contour> contoursOut, FitSplinesExtract fitter, int minNumPoints) {
        if (contourIn.getPoints().size() < minNumPoints) {
            contoursOut.add(contourIn);
        } else {
            fitter.apply(contourIn.pointsDiscrete(), contoursOut);
        }
    }

    private static void fitSplinesAndExtract(List<Point3i> pointsToFit, double rho, List<Point3i> pointsExtra, int numExtraPoints, List<Contour> out) {
        if (numExtraPoints > pointsExtra.size()) {
            numExtraPoints = pointsExtra.size();
        }
        double[] u = SplitContourSmoothingSpline.integerSequence(pointsToFit.size() + numExtraPoints);
        double[] x = SplitContourSmoothingSpline.extractFromPoint(pointsToFit, Tuple3i::x, pointsExtra, numExtraPoints);
        double[] y = SplitContourSmoothingSpline.extractFromPoint(pointsToFit, Tuple3i::y, pointsExtra, numExtraPoints);
        SplitContourSmoothingSpline.extractSplitContour(new SmoothingCubicSpline(u, x, rho), new SmoothingCubicSpline(u, y, rho), u.length, out);
    }

    private static List<Contour> extractSplitContour(SmoothingCubicSpline splineX, SmoothingCubicSpline splineY, int maxEvalPoint, List<Contour> out) {
        double prevDerivative = Double.NaN;
        Contour contour = new Contour();
        double step = 0.05;
        for (double z = 0.0; z <= (double)maxEvalPoint; z += step) {
            double xEval = splineX.evaluate(z);
            double yEval = splineY.evaluate(z);
            double xDerivative = splineX.derivative(z);
            double yDerivative = splineY.derivative(z);
            double derivative = xDerivative / yDerivative;
            if (!Double.isNaN(prevDerivative) && !Double.isNaN(derivative) && Math.signum(derivative) != Math.signum(prevDerivative)) {
                out.add(contour);
                contour = new Contour();
            }
            prevDerivative = derivative;
            contour.getPoints().add(new Point3f((float)xEval, (float)yEval, 0.0f));
        }
        out.add(contour);
        return out;
    }

    private static double[] extractFromPoint(List<Point3i> points, ToIntFunction<Point3i> extracter, List<Point3i> pointsExtra, int numberExtraPoints) {
        int i;
        double[] out = new double[points.size() + numberExtraPoints];
        for (i = 0; i < points.size(); ++i) {
            out[i] = extracter.applyAsInt(points.get(i));
        }
        for (i = 0; i < numberExtraPoints; ++i) {
            out[points.size() + i] = extracter.applyAsInt(pointsExtra.get(i));
        }
        return out;
    }

    private static double[] integerSequence(int size) {
        double[] out = new double[size];
        for (int i = 0; i < size; ++i) {
            out[i] = i;
        }
        return out;
    }

    @Generated
    private SplitContourSmoothingSpline() {
    }

    @FunctionalInterface
    private static interface FitSplinesExtract {
        public void apply(List<Point3i> var1, List<Contour> var2);
    }
}

