/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.convexhull;

import java.util.List;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.points.PointsFromMask;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.plugin.points.bean.convexhull.ConvexHullBase;
import org.anchoranalysis.plugin.points.convexhull.ConvexHullUtilities;
import org.anchoranalysis.spatial.point.Point2i;

public class ConvexHull2D
extends ConvexHullBase {
    @Override
    protected Mask createFromMask(Mask mask, Mask outline) throws ProvisionFailedException {
        try {
            List<Point2i> pointsOnConvexHull = ConvexHullUtilities.convexHull2D(PointsFromMask.listFrom2i((Mask)outline));
            this.changeMaskToShowPointsOnly(outline, pointsOnConvexHull);
            return outline;
        }
        catch (CreateException | OperationFailedException e) {
            throw new ProvisionFailedException(e);
        }
    }

    private void changeMaskToShowPointsOnly(Mask mask, List<Point2i> points) {
        VoxelsAssigner assignerOn = mask.assignOn();
        VoxelsAssigner assignerOff = mask.assignOff();
        assignerOff.toAll();
        points.forEach(point -> assignerOn.toVoxel(point.x(), point.y(), 0));
    }
}

