/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.convexhull;

import com.github.quickhull3d.Point3d;
import com.github.quickhull3d.QuickHull3D;
import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsEqualTo;
import org.anchoranalysis.plugin.points.bean.convexhull.ConvexHullBase;

public class ConvexHull3D
extends ConvexHullBase {
    @Override
    protected Mask createFromMask(Mask maskIn, Mask outline) {
        MessageLogger logger = this.getLogger().messageLogger();
        List<Point3d> extPoints = ConvexHull3D.pointsFromMask(outline);
        Point3d[] pointArr = extPoints.toArray(new Point3d[0]);
        QuickHull3D hull = new QuickHull3D();
        hull.build(pointArr);
        logger.log("Vertices:");
        Point3d[] vertices = hull.getVertices();
        for (int i = 0; i < vertices.length; ++i) {
            Point3d point = vertices[i];
            logger.log(point.x + " " + point.y + " " + point.z);
        }
        logger.log("Faces:");
        int[][] faceIndices = hull.getFaces();
        for (int i = 0; i < faceIndices.length; ++i) {
            for (int k = 0; k < faceIndices[i].length; ++k) {
                logger.log(faceIndices[i][k] + " ");
            }
            logger.log("");
        }
        Channel out = outline.channel();
        Voxels voxelsOut = out.voxels().asByte();
        VoxelsAssigner assignerOn = voxelsOut.assignValue(outline.binaryValuesInt().getOn());
        VoxelsAssigner assignerOff = voxelsOut.assignValue(outline.binaryValuesInt().getOff());
        assignerOff.toAll();
        for (int i = 0; i < vertices.length; ++i) {
            Point3d point = vertices[i];
            assignerOn.toVoxel((int)point.x, (int)point.y, (int)point.z);
        }
        return outline;
    }

    private static List<Point3d> pointsFromMask(Mask mask) {
        ArrayList<Point3d> listOut = new ArrayList<Point3d>();
        BinaryValuesByte binaryValues = mask.binaryValuesByte();
        IterateVoxelsEqualTo.equalToPrimitive((Voxels)mask.voxels(), (byte)binaryValues.getOn(), (x, y, z) -> listOut.add(new Point3d((double)x, (double)y, (double)z)));
        return listOut;
    }
}

