/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.feature;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.mark.conic.Ellipsoid;
import org.anchoranalysis.plugin.points.calculate.ellipsoid.CalculateEllipsoidLeastSquares;

public abstract class EllipsoidBase
extends FeatureSingleObject {
    private static final int MINIMUM_NUMBER_VOXELS = 12;
    @BeanField
    private boolean suppressZ = false;

    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        ObjectMask object = ((FeatureInputSingleObject)input.get()).getObject();
        if (object.voxelsOn().lowerCountExistsThan(12)) {
            return 1.0;
        }
        Ellipsoid ellipsoid = CalculateEllipsoidLeastSquares.of(input, this.suppressZ);
        return this.calculateWithEllipsoid((FeatureInputSingleObject)input.get(), ellipsoid);
    }

    protected abstract double calculateWithEllipsoid(FeatureInputSingleObject var1, Ellipsoid var2) throws FeatureCalculationException;

    @Generated
    public boolean isSuppressZ() {
        return this.suppressZ;
    }

    @Generated
    public void setSuppressZ(boolean suppressZ) {
        this.suppressZ = suppressZ;
    }
}

