/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.feature;

import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.calculate.part.CalculationPart;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.points.fitter.InsufficientPointsException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.plugin.points.bean.feature.EllipticityCalculatorHelper;
import org.anchoranalysis.plugin.points.calculate.ellipse.CalculateEllipseLeastSquares;
import org.anchoranalysis.plugin.points.calculate.ellipse.ObjectWithEllipse;

public class Ellipticity
extends FeatureSingleObject {
    private static final int MINIMUM_NUMBER_VOXELS = 6;

    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        ObjectWithEllipse both;
        FeatureInputSingleObject inputSessionless = (FeatureInputSingleObject)input.get();
        try {
            both = (ObjectWithEllipse)input.calculate((CalculationPart)new CalculateEllipseLeastSquares());
        }
        catch (FeatureCalculationException e) {
            if (e.getCause() instanceof InsufficientPointsException) {
                return 1.0;
            }
            throw new FeatureCalculationException((Throwable)e);
        }
        ObjectMask object = both.getObject();
        if (object.voxelsOn().lowerCountExistsThan(6)) {
            return 1.0;
        }
        return EllipticityCalculatorHelper.calculate(object, (Mark)both.getMark(), inputSessionless.dimensionsRequired());
    }
}

