/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.feature;

import lombok.Generated;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.merge.ObjectMaskMerger;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.mpp.bean.regionmap.RegionMapSingleton;
import org.anchoranalysis.mpp.bean.regionmap.RegionMembershipWithFlags;
import org.anchoranalysis.mpp.mark.Mark;

class EllipticityCalculatorHelper {
    public static double calculate(ObjectMask object, Mark mark, Dimensions dimensions) {
        return EllipticityCalculatorHelper.calculate(object, EllipticityCalculatorHelper.objectMaskCompare(mark, dimensions));
    }

    private static double calculate(ObjectMask object, ObjectMask objectCompare) {
        return EllipticityCalculatorHelper.calculateWithMerged(object, objectCompare, ObjectMaskMerger.merge((ObjectMask)object, (ObjectMask)objectCompare));
    }

    private static double calculateWithMerged(ObjectMask object, ObjectMask objectCompare, ObjectMask merged) {
        int numPixelsCompare = objectCompare.numberVoxelsOn();
        int numUnion = merged.numberVoxelsOn();
        int numIntersection = object.countIntersectingVoxels(objectCompare);
        return EllipticityCalculatorHelper.intDiv(numPixelsCompare, numUnion - numIntersection + numPixelsCompare);
    }

    private static ObjectMask objectMaskCompare(Mark mark, Dimensions dim) {
        RegionMembershipWithFlags rm = RegionMapSingleton.instance().membershipWithFlagsForIndex(0);
        assert (rm.getRegionID() == 0);
        return mark.deriveObject(dim, rm, BinaryValuesByte.getDefault());
    }

    private static double intDiv(int num, int dem) {
        return (double)num / (double)dem;
    }

    @Generated
    private EllipticityCalculatorHelper() {
    }
}

