/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.jet.math.Functions;
import lombok.Generated;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.plugin.points.bean.fitter.FitResult;
import org.anchoranalysis.spatial.point.Point3d;

public class EllipsoidFitHelper {
    public static FitResult createFitResultFromMatrixAandCenter(DoubleMatrix2D matrixA, DoubleMatrix2D matrixCenter, boolean suppressZCovariance) throws PointsFitterException {
        DoubleMatrix2D matrixR = EllipsoidFitHelper.createMatrixR(matrixA, matrixCenter);
        FitResult fitResult = new FitResult();
        EllipsoidFitHelper.setRadiiFromDecomposition(fitResult, EllipsoidFitHelper.createMatrixE(matrixR, suppressZCovariance));
        EllipsoidFitHelper.setCenterFromFirstColumn(fitResult, matrixCenter);
        assert (!Double.isNaN(fitResult.getRadiusX()));
        assert (!Double.isNaN(fitResult.getRadiusY()));
        assert (!Double.isNaN(fitResult.getRadiusZ()));
        assert (fitResult.getRadiusX() > 0.0);
        assert (fitResult.getRadiusY() > 0.0);
        assert (fitResult.getRadiusZ() > 0.0);
        return fitResult;
    }

    private static void setCenterFromFirstColumn(FitResult fitResult, DoubleMatrix2D matrixCenter) {
        fitResult.setCenterPoint(new Point3d(matrixCenter.get(0, 0), matrixCenter.get(1, 0), matrixCenter.get(2, 0)));
    }

    private static DoubleMatrix2D createMatrixE(DoubleMatrix2D matrixR, boolean suppressZCovariance) {
        DoubleMatrix2D e = matrixR.viewPart(0, 0, 3, 3);
        double divVal = matrixR.get(3, 3) * -1.0;
        e.assign(Functions.div((double)divVal));
        if (suppressZCovariance) {
            e.set(2, 0, 0.0);
            e.set(2, 1, 0.0);
            e.set(0, 2, 0.0);
            e.set(1, 2, 0.0);
        }
        return e;
    }

    private static void setRadiiFromDecomposition(FitResult fitResult, DoubleMatrix2D e) throws PointsFitterException {
        try {
            EigenvalueDecomposition evd = new EigenvalueDecomposition(e);
            fitResult.setRadiusX(EllipsoidFitHelper.radiusFromDiagonal(evd, 0));
            fitResult.setRadiusY(EllipsoidFitHelper.radiusFromDiagonal(evd, 1));
            fitResult.setRadiusZ(EllipsoidFitHelper.radiusFromDiagonal(evd, 2));
            fitResult.setRotMatrix(evd.getV());
        }
        catch (ArrayIndexOutOfBoundsException e1) {
            throw new PointsFitterException(String.format("Cannot init EigenValueDecomposition with arg='%s'", e.toString()));
        }
    }

    private static double radiusFromDiagonal(EigenvalueDecomposition evd, int index) {
        double valFromDiagonal = evd.getD().get(index, index);
        return Math.sqrt(1.0 / Math.abs(valFromDiagonal));
    }

    private static DoubleMatrix2D createMatrixR(DoubleMatrix2D matrixA, DoubleMatrix2D matrixCenter) {
        DoubleMatrix2D matrixT = DoubleFactory2D.dense.identity(4);
        matrixT.set(3, 0, matrixCenter.get(0, 0));
        matrixT.set(3, 1, matrixCenter.get(1, 0));
        matrixT.set(3, 2, matrixCenter.get(2, 0));
        return matrixT.zMult(matrixA, null).zMult(matrixT.viewDice(), null);
    }

    @Generated
    private EllipsoidFitHelper() {
    }
}

