/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.SingularValueDecomposition;
import lombok.Generated;

class InverseHelper {
    private static final Algebra ALGEBRA = new Algebra();
    private static final double MACHINE_EPSILON = InverseHelper.calculateMachineEpsilonFloat();

    public static DoubleMatrix2D inverseFor(DoubleMatrix2D matS22) {
        Algebra algebra = new Algebra();
        if (algebra.det(matS22) > 1.0E-9) {
            return ALGEBRA.inverse(matS22);
        }
        return InverseHelper.pesudoInverse(matS22);
    }

    private static DoubleMatrix2D pesudoInverseDiag(DoubleMatrix2D mat) {
        double maxVal = Double.MIN_VALUE;
        for (int i = 0; i < mat.columns(); ++i) {
            double val = mat.get(i, i);
            if (!(val > maxVal)) continue;
            maxVal = val;
        }
        double tol = MACHINE_EPSILON * (double)Math.max(mat.columns(), mat.rows()) * maxVal;
        for (int i = 0; i < mat.columns(); ++i) {
            double val = mat.get(i, i);
            if (val > tol) {
                mat.set(i, i, 1.0 / val);
                continue;
            }
            mat.set(i, i, 0.0);
        }
        return mat;
    }

    private static DoubleMatrix2D pesudoInverse(DoubleMatrix2D matrix) {
        SingularValueDecomposition svd = new SingularValueDecomposition(matrix);
        return svd.getV().zMult(InverseHelper.pesudoInverseDiag(svd.getS()), null).zMult(svd.getU().viewDice(), null);
    }

    private static float calculateMachineEpsilonFloat() {
        float machEps = 1.0f;
        while ((double)((float)(1.0 + (double)(machEps /= 2.0f) / 2.0)) != 1.0) {
        }
        return machEps;
    }

    @Generated
    private InverseHelper() {
    }
}

