/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.jet.math.Functions;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.mpp.mark.conic.Ellipsoid;
import org.anchoranalysis.plugin.points.bean.fitter.ConicFitterBase;
import org.anchoranalysis.plugin.points.bean.fitter.EllipsoidFitHelper;
import org.anchoranalysis.plugin.points.bean.fitter.FitResult;
import org.anchoranalysis.plugin.points.bean.fitter.InverseHelper;
import org.anchoranalysis.plugin.points.bean.fitter.MatrixCreator;
import org.anchoranalysis.spatial.point.Point3f;

public class LinearLeastSquaresEllipsoidFitter
extends ConicFitterBase {
    @BeanField
    private double minRadius = 0.55;
    @BeanField
    private boolean suppressZCovariance = false;

    public boolean isCompatibleWith(Mark testMark) {
        return testMark instanceof Ellipsoid;
    }

    public void fit(List<Point3f> points, Mark mark, Dimensions dimensions) throws PointsFitterException {
        DoubleMatrix2D matCInverse = InverseHelper.inverseFor(MatrixCreator.createConstraintMatrix().viewPart(0, 0, 6, 6));
        DoubleMatrix2D matD = MatrixCreator.createDesignMatrixWithOnes(points, (float)this.getSubtractRadii());
        DoubleMatrix2D matS = matD.viewDice().zMult(matD, null);
        this.createFitResultFromMatS(matS, matCInverse).applyFitResultToMark((Ellipsoid)mark, dimensions, this.getShell());
    }

    private FitResult createFitResultFromMatS(DoubleMatrix2D matS, DoubleMatrix2D matCInverse) throws PointsFitterException {
        DoubleMatrix2D matS11 = matS.viewPart(0, 0, 6, 6);
        DoubleMatrix2D matS12 = matS.viewPart(0, 6, 6, 4);
        DoubleMatrix2D matS21 = matS.viewPart(6, 0, 4, 6);
        DoubleMatrix2D matS22 = matS.viewPart(6, 6, 4, 4);
        DoubleMatrix2D matS22Inv = InverseHelper.inverseFor(matS22);
        matS22Inv.assign(Functions.mult((double)-1.0));
        DoubleMatrix2D mult1 = matS22Inv.zMult(matS21, null);
        DoubleMatrix2D mult3 = this.createMult3(mult1, matCInverse, matS11, matS12);
        return this.createFitResultFromDecomposition(mult1, mult3);
    }

    private DoubleMatrix2D createMult3(DoubleMatrix2D mult1, DoubleMatrix2D matCInverse, DoubleMatrix2D matS11, DoubleMatrix2D matS12) {
        DoubleMatrix2D mult2 = matS12.zMult(mult1, null);
        mult2.assign(matS11, Functions.plus);
        return matCInverse.zMult(mult2, null);
    }

    private FitResult createFitResultFromDecomposition(DoubleMatrix2D mult1, DoubleMatrix2D mult3) throws PointsFitterException {
        EigenvalueDecomposition e = new EigenvalueDecomposition(mult3);
        int index = this.selectEigenVector(e.getRealEigenvalues());
        if (index == -1) {
            throw new PointsFitterException("Cannot find suitable eigen-value");
        }
        DoubleMatrix1D v1 = e.getV().viewColumn(index);
        DoubleMatrix1D v2 = mult1.zMult(v1, null);
        return this.createFitResult(v1, v2);
    }

    private FitResult createFitResult(DoubleMatrix1D v1, DoubleMatrix1D v2) throws PointsFitterException {
        DoubleMatrix2D matA = MatrixCreator.createMatrixA(v1, v2);
        FitResult fitResult = EllipsoidFitHelper.createFitResultFromMatrixAandCenter(matA, MatrixCreator.createMatrixCenter(matA, v2), this.suppressZCovariance);
        fitResult.applyRadiiSubtractScale(this.getSubtractRadii(), this.getScaleRadii());
        fitResult.imposeMinimumRadius(this.minRadius);
        return fitResult;
    }

    private int selectEigenVector(DoubleMatrix1D eigenvalues) {
        int maxIndex = -1;
        double maxValue = 0.0;
        for (int i = 0; i < eigenvalues.size(); ++i) {
            double val = eigenvalues.get(i);
            if (i != 0 && !(val > maxValue)) continue;
            maxValue = val;
            maxIndex = i;
        }
        return maxIndex;
    }

    @Generated
    public double getMinRadius() {
        return this.minRadius;
    }

    @Generated
    public void setMinRadius(double minRadius) {
        this.minRadius = minRadius;
    }

    @Generated
    public boolean isSuppressZCovariance() {
        return this.suppressZCovariance;
    }

    @Generated
    public void setSuppressZCovariance(boolean suppressZCovariance) {
        this.suppressZCovariance = suppressZCovariance;
    }
}

