/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import java.util.List;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.mpp.mark.Mark;
import org.anchoranalysis.plugin.points.bean.fitter.ConicFitterBase;
import org.anchoranalysis.plugin.points.bean.fitter.ConicFitterUtilities;
import org.anchoranalysis.spatial.point.Point3f;

public abstract class LinearLeastSquaresViaNormalEquationBase
extends ConicFitterBase {
    public void fit(List<Point3f> points, Mark mark, Dimensions dimensions) throws PointsFitterException {
        if (points.size() < this.minNumPoints()) {
            throw new PointsFitterException(String.format("Must have at least %d points to fit", this.minNumPoints()));
        }
        DoubleMatrix2D coefficients = LinearLeastSquaresViaNormalEquationBase.solveNormalEquation(this.createDesignMatrix(points));
        this.applyCoefficientsToMark(coefficients, mark, dimensions);
    }

    protected abstract int minNumPoints();

    protected abstract void applyCoefficientsToMark(DoubleMatrix2D var1, Mark var2, Dimensions var3) throws PointsFitterException;

    protected abstract DoubleMatrix2D createDesignMatrix(List<Point3f> var1);

    private static DoubleMatrix2D solveNormalEquation(DoubleMatrix2D matrixD) throws PointsFitterException {
        DoubleMatrix2D ones = DoubleFactory2D.dense.make(matrixD.rows(), 1, 1.0);
        return ConicFitterUtilities.matrixLeftDivide(matrixD.viewDice().zMult(matrixD, null), matrixD.viewDice().zMult(ones, null));
    }
}

