/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.points.bean.fitter;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.jet.math.Functions;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.mpp.bean.points.fitter.PointsFitterException;
import org.anchoranalysis.plugin.points.bean.fitter.ConicFitterUtilities;
import org.anchoranalysis.spatial.point.Point3f;

class MatrixCreator {
    public static DoubleMatrix2D createMatrixA(DoubleMatrix1D v1, DoubleMatrix1D v2) {
        DoubleMatrix2D m = DoubleFactory2D.dense.make(4, 4);
        m.set(0, 0, v1.get(0));
        m.set(1, 1, v1.get(1));
        m.set(2, 2, v1.get(2));
        m.set(3, 3, v2.get(3));
        m.set(1, 0, v1.get(5));
        m.set(0, 1, v1.get(5));
        m.set(2, 0, v1.get(4));
        m.set(0, 2, v1.get(4));
        m.set(3, 0, v2.get(0));
        m.set(0, 3, v2.get(0));
        m.set(1, 2, v1.get(3));
        m.set(2, 1, v1.get(3));
        m.set(1, 3, v2.get(1));
        m.set(3, 1, v2.get(1));
        m.set(2, 3, v2.get(2));
        m.set(3, 2, v2.get(2));
        return m;
    }

    public static DoubleMatrix2D createConstraintMatrix() {
        DoubleMatrix2D mat = DoubleFactory2D.dense.make(10, 10);
        for (int i = 0; i < 6; ++i) {
            mat.set(i, i, -1.0);
        }
        mat.set(0, 1, 1.0);
        mat.set(0, 2, 1.0);
        mat.set(1, 0, 1.0);
        mat.set(1, 2, 1.0);
        mat.set(2, 0, 1.0);
        mat.set(2, 1, 1.0);
        return mat;
    }

    public static DoubleMatrix2D createDesignMatrixWithOnes(List<Point3f> points, float inputPointShift) {
        DoubleMatrix2D matrix = DoubleFactory2D.dense.make(points.size(), 10);
        for (int i = 0; i < points.size(); ++i) {
            Point3f point = points.get(i);
            float x = point.x() + inputPointShift;
            float y = point.y() + inputPointShift;
            float z = point.z() + inputPointShift;
            matrix.set(i, 0, Math.pow(x, 2.0));
            matrix.set(i, 1, Math.pow(y, 2.0));
            matrix.set(i, 2, Math.pow(z, 2.0));
            matrix.set(i, 3, (double)(2.0f * y * z));
            matrix.set(i, 4, (double)(2.0f * x * z));
            matrix.set(i, 5, (double)(2.0f * x * y));
            matrix.set(i, 6, (double)(2.0f * x));
            matrix.set(i, 7, (double)(2.0f * y));
            matrix.set(i, 8, (double)(2.0f * z));
            matrix.set(i, 9, 1.0);
        }
        return matrix;
    }

    public static DoubleMatrix2D createMatrixCenter(DoubleMatrix2D matrixA, DoubleMatrix1D v2) throws PointsFitterException {
        DoubleMatrix2D first = matrixA.viewPart(0, 0, 3, 3).copy().assign(Functions.mult((double)-1.0));
        DoubleMatrix2D second = DoubleFactory2D.dense.make(3, 1);
        second.viewColumn(0).assign(v2.viewPart(0, 3));
        return ConicFitterUtilities.matrixLeftDivide(first, second);
    }

    @Generated
    private MatrixCreator() {
    }
}

